/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class RegistryLookupValueResolver<T>
implements ValueResolver<T> {
    private final String key;
    private MuleContext muleContext;

    public RegistryLookupValueResolver(String key, MuleContext muleContext) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)key) ? 1 : 0) != 0, (String)"key cannot be null or blank");
        this.key = key;
        this.muleContext = muleContext;
    }

    @Override
    public T resolve(Event event) throws MuleException {
        Object value = this.muleContext.getRegistry().get(this.key);
        if (value == null) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)String.format("Element '%s' is not defined in the Mule Registry", this.key)));
        }
        return (T)value;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

