/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class MapValueResolver<K, V>
implements ValueResolver<Map<K, V>> {
    private final Class<? extends Map> mapType;
    private final List<ValueResolver<V>> valueResolvers;
    private final List<ValueResolver<K>> keyResolvers;

    public MapValueResolver(Class<? extends Map> mapType, List<ValueResolver<K>> keyResolvers, List<ValueResolver<V>> valueResolvers) {
        IntrospectionUtils.checkInstantiable(mapType);
        Preconditions.checkArgument((keyResolvers != null && valueResolvers != null ? 1 : 0) != 0, (String)"resolvers cannot be null");
        Preconditions.checkArgument((keyResolvers.size() == valueResolvers.size() ? 1 : 0) != 0, (String)"exactly one valueResolver for each keyResolver is required");
        this.mapType = mapType;
        this.keyResolvers = keyResolvers;
        this.valueResolvers = valueResolvers;
    }

    public static <K, V> MapValueResolver<K, V> of(Class<? extends Map> mapType, List<ValueResolver<K>> keyResolvers, List<ValueResolver<V>> valueResolvers) {
        if (ConcurrentMap.class.equals(mapType)) {
            return new MapValueResolver<K, V>(ConcurrentHashMap.class, keyResolvers, valueResolvers);
        }
        if (Map.class.equals(mapType)) {
            return new MapValueResolver<K, V>(HashMap.class, keyResolvers, valueResolvers);
        }
        return new MapValueResolver<K, V>(mapType, keyResolvers, valueResolvers);
    }

    @Override
    public Map<K, V> resolve(Event event) throws MuleException {
        Map<K, V> map = this.instantiateMap();
        Iterator<ValueResolver<K>> keyIt = this.keyResolvers.iterator();
        Iterator<ValueResolver<V>> valueIt = this.valueResolvers.iterator();
        while (keyIt.hasNext() && valueIt.hasNext()) {
            try {
                map.put(keyIt.next().resolve(event), valueIt.next().resolve(event));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return map;
    }

    @Override
    public boolean isDynamic() {
        try {
            return MuleExtensionUtils.hasAnyDynamic(this.keyResolvers) || MuleExtensionUtils.hasAnyDynamic(this.valueResolvers);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<K, V> instantiateMap() {
        try {
            return this.mapType.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create instance of " + this.mapType.getName(), e);
        }
    }
}

