/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ExpressionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeTransformer;

public class ExpressionTypedValueValueResolver<T>
extends ExpressionValueResolver<TypedValue<T>> {
    private final Class<T> expectedClass;
    private TypeSafeTransformer typeSafeTransformer;

    public ExpressionTypedValueValueResolver(String expression, Class<T> expectedClass, MuleContext muleContext) {
        super(expression, muleContext);
        this.expectedClass = expectedClass;
        this.typeSafeTransformer = new TypeSafeTransformer(muleContext);
    }

    @Override
    public TypedValue<T> resolve(Event event) throws MuleException {
        this.initEvaluator();
        TypedValue typedValue = this.evaluator.resolveTypedValue(event, Event.builder((Event)event));
        if (ClassUtils.isInstance(this.expectedClass, (Object)typedValue.getValue())) {
            return typedValue;
        }
        DataType expectedDataType = DataType.builder().type(this.expectedClass).mediaType(typedValue.getDataType().getMediaType()).build();
        return new TypedValue(this.typeSafeTransformer.transform(typedValue.getValue(), typedValue.getDataType(), expectedDataType, event), expectedDataType);
    }
}

