/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import org.mule.runtime.extension.api.runtime.operation.InterceptingCallback;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.operation.ExecutionMediator;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public final class InterceptingExecutionMediator
implements ExecutionMediator {
    private final ExecutionMediator intercepted;

    public InterceptingExecutionMediator(ExecutionMediator intercepted) {
        this.intercepted = intercepted;
    }

    @Override
    public Publisher<Object> execute(OperationExecutor executor, ExecutionContextAdapter context) {
        try {
            Object resultValue = Mono.from(this.intercepted.execute(executor, context)).block();
            if (!(resultValue instanceof InterceptingCallback)) {
                throw new IllegalStateException(String.format("%s '%s' was expected to return a '%s' but a '%s' was found instead", NameUtils.getComponentModelTypeName((Object)context.getComponentModel()), context.getComponentModel().getName(), InterceptingCallback.class.getSimpleName(), resultValue));
            }
            context.setVariable("MULE_INTERCEPTING_CALLBACK_PARAM", resultValue);
            return Mono.just((Object)((InterceptingCallback)resultValue).getResult());
        }
        catch (Exception e) {
            return Mono.error((Throwable)e);
        }
    }
}

