/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ErrorTypeHandlerConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.PoolingConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ReconnectableConnectionProviderWrapper;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ResolverSetBasedObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConnectionProviderObjectBuilder<C>
extends ResolverSetBasedObjectBuilder<ConnectionProvider<C>> {
    private final ConnectionProviderModel providerModel;
    private final boolean disableValidation;
    private final RetryPolicyTemplate retryPolicyTemplate;
    private final PoolingProfile poolingProfile;
    private final ExtensionModel extensionModel;
    private final MuleContext muleContext;
    private String ownerConfigName = "";

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, ConnectionManagerAdapter connectionManager, ExtensionModel extensionModel, MuleContext muleContext) {
        this(providerModel, resolverSet, null, false, null, connectionManager, extensionModel, muleContext);
    }

    public ConnectionProviderObjectBuilder(ConnectionProviderModel providerModel, ResolverSet resolverSet, PoolingProfile poolingProfile, boolean disableValidation, RetryPolicyTemplate retryPolicyTemplate, ConnectionManagerAdapter connectionManager, ExtensionModel extensionModel, MuleContext muleContext) {
        super(MuleExtensionUtils.getConnectionProviderFactory(providerModel).getObjectType(), (ParameterizedModel)providerModel, resolverSet);
        this.providerModel = providerModel;
        this.poolingProfile = poolingProfile;
        this.extensionModel = extensionModel;
        this.muleContext = muleContext;
        this.retryPolicyTemplate = retryPolicyTemplate != null ? retryPolicyTemplate : connectionManager.getDefaultRetryPolicyTemplate();
        this.disableValidation = disableValidation;
    }

    @Override
    public ConnectionProvider<C> build(ResolverSetResult result) throws MuleException {
        Object provider = (ConnectionProvider)super.build(result);
        MuleExtensionUtils.injectConfigName((EnrichableModel)this.providerModel, provider, this.ownerConfigName);
        ConnectionManagementType connectionManagementType = this.providerModel.getConnectionManagementType();
        provider = connectionManagementType == ConnectionManagementType.POOLING ? new PoolingConnectionProviderWrapper(provider, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate) : new ReconnectableConnectionProviderWrapper(provider, this.disableValidation, this.retryPolicyTemplate);
        provider = new ErrorTypeHandlerConnectionProviderWrapper(provider, this.muleContext, this.extensionModel, this.retryPolicyTemplate);
        return provider;
    }

    @Override
    protected ConnectionProvider instantiateObject() {
        return MuleExtensionUtils.getConnectionProviderFactory(this.providerModel).newInstance();
    }

    @Override
    public boolean isDynamic() {
        return this.resolverSet.isDynamic();
    }

    public void setOwnerConfigName(String ownerConfigName) {
        this.ownerConfigName = ownerConfigName;
    }
}

