/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;

public class OperationParametersTypeModelValidator
implements ExtensionModelValidator {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final Set<MetadataType> forbiddenTypes = ImmutableSet.builder().add((Object)this.typeLoader.load(Event.class)).add((Object)this.typeLoader.load(Message.class)).build();

    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        new IdempotentExtensionWalker(){

            protected void onOperation(OperationModel model) {
                model.getAllParameterModels().forEach(parameterModel -> {
                    MetadataType parameterType = parameterModel.getType();
                    if (parameterType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && this.isForbiddenType(parameterType)) {
                        problemsReporter.addError(new Problem((NamedObject)model, String.format("Operation '%s' contains parameter '%s' of type '%s' which is forbidden", model.getName(), parameterModel.getName(), MetadataTypeUtils.getTypeId((MetadataType)parameterType).get())));
                    }
                });
            }

            private boolean isForbiddenType(MetadataType parameterType) {
                return OperationParametersTypeModelValidator.this.forbiddenTypes.contains(parameterType);
            }
        }.walk(extensionModel);
    }
}

