/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.streaming;

import java.io.IOException;
import java.util.List;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.streaming.object.Producer;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.runtime.streaming.PagingProviderWrapper;

public final class PagingProviderProducer<T>
implements Producer<List<T>> {
    private PagingProvider<Object, T> delegate;
    private final ConfigurationInstance config;
    private final ConnectionManager connectionManager;

    public PagingProviderProducer(PagingProvider<Object, T> delegate, ConfigurationInstance config, ConnectionManager manager) {
        this.delegate = new PagingProviderWrapper<Object, T>(delegate);
        this.config = config;
        this.connectionManager = manager;
    }

    public List<T> produce() {
        return this.performWithConnection(connection -> this.delegate.getPage(connection));
    }

    public int size() {
        return this.performWithConnection(connection -> this.delegate.getTotalResults(connection)).orElse(-1);
    }

    private <R> R performWithConnection(Function<Object, R> function) {
        ConnectionHandler connectionHandler = null;
        try {
            connectionHandler = this.connectionManager.getConnection(this.config.getValue());
            R r = function.apply(connectionHandler.getConnection());
            return r;
        }
        catch (ConnectionException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Could not obtain a connection for the configuration"), (Throwable)e);
        }
        finally {
            if (connectionHandler != null) {
                connectionHandler.release();
            }
        }
    }

    public void close() throws IOException {
        this.delegate.close();
    }
}

