/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.metadata.MediaType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.core.util.collection.ImmutableMapCollector;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.ParameterResolver;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.execution.ArgumentResolverDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ByParameterNameArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.CompletionCallbackArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConfigurationArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ErrorArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MediaTypeArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterGroupArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParameterResolverArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SecurityContextHandlerArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.SourceCallbackContextArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypedValueArgumentResolver;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class MethodArgumentResolverDelegate
implements ArgumentResolverDelegate {
    private static final ArgumentResolver<Object> CONFIGURATION_ARGUMENT_RESOLVER = new ConfigurationArgumentResolver();
    private static final ArgumentResolver<Object> CONNECTOR_ARGUMENT_RESOLVER = new ConnectionArgumentResolver();
    private static final ArgumentResolver<MediaType> MEDIA_TYPE_ARGUMENT_RESOLVER = new MediaTypeArgumentResolver();
    private static final ArgumentResolver<SourceCallbackContext> SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER = new SourceCallbackContextArgumentResolver();
    private static final ArgumentResolver<Error> ERROR_ARGUMENT_RESOLVER = new ErrorArgumentResolver();
    private static final ArgumentResolver<CompletionCallback> NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER = new CompletionCallbackArgumentResolver();
    private static final ArgumentResolver<AuthenticationHandler> SECURITY_CONTEXT_HANDLER = new SecurityContextHandlerArgumentResolver();
    private final Method method;
    private final JavaTypeLoader typeLoader = new JavaTypeLoader(this.getClass().getClassLoader());
    private ArgumentResolver<? extends Object>[] argumentResolvers;
    private Map<Parameter, ParameterGroupArgumentResolver<? extends Object>> parameterGroupResolvers;

    public MethodArgumentResolverDelegate(List<ParameterGroupModel> parameterGroupModels, Method method) {
        this.method = method;
        this.initArgumentResolvers(parameterGroupModels);
    }

    private void initArgumentResolvers(List<ParameterGroupModel> parameterGroupModels) {
        Object[] parameterTypes = this.method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameterTypes)) {
            this.argumentResolvers = new ArgumentResolver[0];
            return;
        }
        this.argumentResolvers = new ArgumentResolver[parameterTypes.length];
        Annotation[][] parameterAnnotations = this.method.getParameterAnnotations();
        Parameter[] parameters = this.method.getParameters();
        this.parameterGroupResolvers = this.getParameterGroupResolvers(parameterGroupModels);
        List<String> paramNames = MuleExtensionAnnotationParser.getParamNames(this.method);
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object parameterType = parameterTypes[i];
            Map<Class<? extends Annotation>, Annotation> annotations = MuleExtensionAnnotationParser.toMap(parameterAnnotations[i]);
            ArgumentResolver<Object> argumentResolver = annotations.containsKey(UseConfig.class) ? CONFIGURATION_ARGUMENT_RESOLVER : (annotations.containsKey(Connection.class) ? CONNECTOR_ARGUMENT_RESOLVER : (Error.class.isAssignableFrom((Class<?>)parameterType) ? ERROR_ARGUMENT_RESOLVER : (SourceCallbackContext.class.isAssignableFrom((Class<?>)parameterType) ? SOURCE_CALLBACK_CONTEXT_ARGUMENT_RESOLVER : (IntrospectionUtils.isParameterContainer(annotations.keySet(), this.typeLoader.load((Type)parameterType)) && !((ParameterGroup)annotations.get(ParameterGroup.class)).showInDsl() ? (ArgumentResolver<CompletionCallback>)this.parameterGroupResolvers.get(parameters[i]) : (ParameterResolver.class.isAssignableFrom((Class<?>)parameterType) ? new ParameterResolverArgumentResolver(paramNames.get(i)) : (TypedValue.class.isAssignableFrom((Class<?>)parameterType) ? new TypedValueArgumentResolver(paramNames.get(i)) : (CompletionCallback.class.isAssignableFrom((Class<?>)parameterType) ? NON_BLOCKING_CALLBACK_ARGUMENT_RESOLVER : (MediaType.class.equals(parameterType) ? MEDIA_TYPE_ARGUMENT_RESOLVER : (AuthenticationHandler.class.equals(parameterType) ? SECURITY_CONTEXT_HANDLER : new ByParameterNameArgumentResolver<CompletionCallback>(paramNames.get(i)))))))))));
            this.argumentResolvers[i] = argumentResolver;
        }
    }

    @Override
    public Object[] resolve(ExecutionContext executionContext, Class<?>[] parameterTypes) {
        Object[] parameterValues = new Object[this.argumentResolvers.length];
        int i = 0;
        for (ArgumentResolver<? extends Object> argumentResolver : this.argumentResolvers) {
            parameterValues[i++] = argumentResolver.resolve(executionContext);
        }
        return this.resolvePrimitiveTypes(parameterTypes, parameterValues);
    }

    private Object[] resolvePrimitiveTypes(Class<?>[] parametersType, Object[] parameterValues) {
        Object[] resolvedParameters = new Object[parameterValues.length];
        for (int i = 0; i < parameterValues.length; ++i) {
            Object parameterValue = parameterValues[i];
            resolvedParameters[i] = parameterValue == null ? this.resolvePrimitiveTypeDefaultValue(parametersType[i]) : parameterValue;
        }
        return resolvedParameters;
    }

    private Object resolvePrimitiveTypeDefaultValue(Class<?> type) {
        if (type.equals(Byte.TYPE)) {
            return (byte)0;
        }
        if (type.equals(Short.TYPE)) {
            return (short)0;
        }
        if (type.equals(Integer.TYPE)) {
            return 0;
        }
        if (type.equals(Long.TYPE)) {
            return 0L;
        }
        if (type.equals(Float.TYPE)) {
            return Float.valueOf(0.0f);
        }
        if (type.equals(Double.TYPE)) {
            return 0.0;
        }
        if (type.equals(Boolean.TYPE)) {
            return false;
        }
        if (type.equals(Character.TYPE)) {
            return Character.valueOf('\u0000');
        }
        return null;
    }

    private Map<Parameter, ParameterGroupArgumentResolver<? extends Object>> getParameterGroupResolvers(List<ParameterGroupModel> parameterGroupModels) {
        return (Map)parameterGroupModels.stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).orElse(null)).filter(group -> group != null && group.getContainer() instanceof Parameter).collect(new ImmutableMapCollector(group -> (Parameter)group.getContainer(), ParameterGroupArgumentResolver::new));
    }
}

