/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKeyProvider;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataKeysContainerBuilder;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.resolving.MetadataFailure;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.metadata.DefaultMetadataContext;
import org.mule.runtime.core.internal.metadata.MuleMetadataService;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.module.extension.internal.runtime.config.StaticConfigurationProvider;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConfigurationProviderMetadataAdapter
extends StaticConfigurationProvider
implements MetadataKeyProvider {
    @Inject
    private MuleMetadataService metadataService;
    @Inject
    protected ConnectionManagerAdapter connectionManager;

    public ConfigurationProviderMetadataAdapter(String name, ExtensionModel extensionModel, ConfigurationModel configurationModel, ConfigurationInstance configuration) {
        super(name, extensionModel, configurationModel, configuration);
    }

    public MetadataResult<MetadataKeysContainer> getMetadataKeys() throws MetadataResolvingException {
        MetadataKeysContainerBuilder keysBuilder = MetadataKeysContainerBuilder.getInstance();
        try {
            MetadataContext metadataContext = this.getMetadataContext();
            this.addComponentKeys(this.getConfigurationModel().getOperationModels(), metadataContext, keysBuilder);
            this.addComponentKeys(this.getConfigurationModel().getSourceModels(), metadataContext, keysBuilder);
            metadataContext.dispose();
        }
        catch (Exception e) {
            return MetadataResult.failure((MetadataFailure[])new MetadataFailure[]{MetadataFailure.Builder.newFailure((Exception)e).onKeys()});
        }
        return MetadataResult.success((Object)keysBuilder.build());
    }

    private void addComponentKeys(List<? extends ComponentModel> components, MetadataContext metadataContext, MetadataKeysContainerBuilder keysBuilder) throws MetadataResolvingException, ConnectionException {
        for (ComponentModel componentModel : components) {
            TypeKeysResolver keysResolver = MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)componentModel).getKeyResolver();
            String categoryName = keysResolver.getCategoryName();
            if ("NullCategory".equals(categoryName) || keysBuilder.containsCategory(categoryName)) continue;
            keysBuilder.add(categoryName, keysResolver.getKeys(metadataContext));
        }
    }

    private MetadataContext getMetadataContext() throws MetadataResolvingException, ConnectionException {
        Event fakeEvent = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new DefaultMetadataContext(Optional.of(this.get(fakeEvent)), (ConnectionManager)this.connectionManager, this.metadataService.getMetadataCache(this.getName()), ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(MuleExtensionUtils.getClassLoader(this.getExtensionModel())));
    }
}

