/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.validation;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.connectivity.TransactionalConnection;
import org.mule.runtime.extension.api.loader.ExtensionModelValidator;
import org.mule.runtime.extension.api.loader.Problem;
import org.mule.runtime.extension.api.loader.ProblemsReporter;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConnectionProviderModelValidator
implements ExtensionModelValidator {
    public void validate(ExtensionModel extensionModel, final ProblemsReporter problemsReporter) {
        HashSet<ConnectionProviderModel> globalConnectionProviders = new HashSet<ConnectionProviderModel>();
        HashMultimap configLevelConnectionProviders = HashMultimap.create();
        new ExtensionWalker((Multimap)configLevelConnectionProviders, globalConnectionProviders){
            final /* synthetic */ Multimap val$configLevelConnectionProviders;
            final /* synthetic */ Set val$globalConnectionProviders;
            {
                this.val$configLevelConnectionProviders = multimap;
                this.val$globalConnectionProviders = set;
            }

            public void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                ConnectionProviderModelValidator.this.validateTransactions(model, problemsReporter);
                if (owner instanceof ConfigurationModel) {
                    this.val$configLevelConnectionProviders.put((Object)((ConfigurationModel)owner), (Object)model);
                } else {
                    this.val$globalConnectionProviders.add(model);
                }
            }
        }.walk(extensionModel);
        this.validateGlobalConnectionTypes(extensionModel, globalConnectionProviders, problemsReporter);
        this.validateConfigLevelConnectionTypes((Multimap<ConfigurationModel, ConnectionProviderModel>)configLevelConnectionProviders, problemsReporter);
    }

    private void validateTransactions(ConnectionProviderModel connectionProviderModel, ProblemsReporter problemsReporter) {
        Class providerType = connectionProviderModel.getModelProperty(ImplementingTypeModelProperty.class).map(ImplementingTypeModelProperty::getType).orElse(null);
        Class<?> connectionType = MuleExtensionUtils.getConnectionType(connectionProviderModel);
        if (providerType != null && CachedConnectionProvider.class.isAssignableFrom(providerType) && TransactionalConnection.class.isAssignableFrom(connectionType)) {
            problemsReporter.addError(new Problem((NamedObject)connectionProviderModel, String.format("Cached connection provider '%s' provides transactional connections. Transactional connections cannot be produced by cached providers, since the same connection cannot join two different transactions at once", connectionProviderModel.getName())));
        }
    }

    private void validateGlobalConnectionTypes(ExtensionModel extensionModel, Set<ConnectionProviderModel> globalConnectionProviders, final ProblemsReporter problemsReporter) {
        if (globalConnectionProviders.isEmpty()) {
            return;
        }
        for (final ConnectionProviderModel connectionProviderModel : globalConnectionProviders) {
            final Class<?> connectionType = MuleExtensionUtils.getConnectionType(connectionProviderModel);
            new IdempotentExtensionWalker(){

                protected void onOperation(OperationModel operationModel) {
                    ConnectionProviderModelValidator.this.validateConnectionTypes(connectionProviderModel, (ComponentModel)operationModel, connectionType, problemsReporter);
                }

                protected void onSource(SourceModel sourceModel) {
                    ConnectionProviderModelValidator.this.validateConnectionTypes(connectionProviderModel, (ComponentModel)sourceModel, connectionType, problemsReporter);
                }
            }.walk(extensionModel);
        }
    }

    private void validateConfigLevelConnectionTypes(Multimap<ConfigurationModel, ConnectionProviderModel> configLevelConnectionProviders, ProblemsReporter problemsReporter) {
        configLevelConnectionProviders.asMap().forEach((configModel, providerModels) -> {
            for (ConnectionProviderModel providerModel : providerModels) {
                Class<?> connectionType = MuleExtensionUtils.getConnectionType(providerModel);
                configModel.getOperationModels().forEach(operationModel -> this.validateConnectionTypes(providerModel, (ComponentModel)operationModel, connectionType, problemsReporter));
            }
        });
    }

    private <T> Optional<Class<T>> getConnectionType(EnrichableModel model) {
        Optional<ConnectivityModelProperty> connectivityProperty = model.getModelProperty(ConnectivityModelProperty.class);
        if (!connectivityProperty.isPresent() && model instanceof ParameterizedModel) {
            connectivityProperty = ((ParameterizedModel)model).getAllParameterModels().stream().map(p -> p.getModelProperty(ConnectivityModelProperty.class).orElse(null)).filter(p -> p != null).findFirst();
        }
        return connectivityProperty.map(property -> property.getConnectionType());
    }

    private void validateConnectionTypes(ConnectionProviderModel providerModel, ComponentModel componentModel, Class<?> providerConnectionType, ProblemsReporter problemsReporter) {
        this.getConnectionType((EnrichableModel)componentModel).ifPresent(connectionType -> {
            if (!connectionType.isAssignableFrom(providerConnectionType)) {
                problemsReporter.addError(new Problem((NamedObject)providerModel, String.format("Component '%s' requires a connection of type '%s'. However, it also defines connection provider '%s' which yields connections of incompatible type '%s'", componentModel.getName(), connectionType.getName(), providerModel.getName(), providerConnectionType.getName())));
            }
        });
    }
}

