/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.java;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mule.runtime.api.connection.CachedConnectionProvider;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.PoolingConnectionProvider;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.DeclaresExternalLibraries;
import org.mule.runtime.api.meta.model.declaration.fluent.HasConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclarer;
import org.mule.runtime.extension.api.exception.IllegalConnectionProviderModelDefinitionException;
import org.mule.runtime.module.extension.internal.loader.java.AbstractModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.DefaultConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.loader.java.JavaModelLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionProviderFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.ConnectionProviderElement;
import org.mule.runtime.module.extension.internal.loader.java.type.WithConnectionProviders;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;

final class ConnectionProviderModelLoaderDelegate
extends AbstractModelLoaderDelegate {
    private static final String CUSTOM_CONNECTION_PROVIDER_SUFFIX = "-connection";
    private static final String CONNECTION_PROVIDER = "Connection Provider";
    private final Map<Class<?>, ConnectionProviderDeclarer> connectionProviderDeclarers = new HashMap();

    ConnectionProviderModelLoaderDelegate(JavaModelLoaderDelegate loader) {
        super(loader);
    }

    void declareConnectionProviders(HasConnectionProviderDeclarer declarer, WithConnectionProviders withConnectionProviders) {
        withConnectionProviders.getConnectionProviders().forEach(provider -> this.declareConnectionProvider(declarer, (ConnectionProviderElement)provider));
    }

    private void declareConnectionProvider(HasConnectionProviderDeclarer declarer, ConnectionProviderElement providerType) {
        List<Class<?>> providerGenerics;
        Class providerClass = providerType.getDeclaringClass();
        ConnectionProviderDeclarer providerDeclarer = this.connectionProviderDeclarers.get(providerClass);
        if (providerDeclarer != null) {
            declarer.withConnectionProvider(providerDeclarer);
            return;
        }
        String name = providerType.getAlias() + CUSTOM_CONNECTION_PROVIDER_SUFFIX;
        String description = providerType.getDescription();
        if (providerType.getName().equals(providerType.getAlias())) {
            name = "connection";
        }
        if ((providerGenerics = providerType.getInterfaceGenerics(ConnectionProvider.class)).size() != 1) {
            throw new IllegalConnectionProviderModelDefinitionException(String.format("Connection provider class '%s' was expected to have 1 generic type (for the connection type) but %d were found", providerType.getName(), providerGenerics.size()));
        }
        providerDeclarer = declarer.withConnectionProvider(name).describedAs(description).withModelProperty((ModelProperty)new ConnectionProviderFactoryModelProperty(new DefaultConnectionProviderFactory(providerClass, this.getExtensionType().getClassLoader()))).withModelProperty((ModelProperty)new ConnectionTypeModelProperty(providerGenerics.get(0))).withModelProperty((ModelProperty)new ImplementingTypeModelProperty(providerClass));
        this.loader.parseExternalLibs(providerType, (DeclaresExternalLibraries)providerDeclarer);
        ConnectionManagementType managementType = ConnectionManagementType.NONE;
        if (PoolingConnectionProvider.class.isAssignableFrom(providerClass)) {
            managementType = ConnectionManagementType.POOLING;
        } else if (CachedConnectionProvider.class.isAssignableFrom(providerClass)) {
            managementType = ConnectionManagementType.CACHED;
        }
        providerDeclarer.withConnectionManagementType(managementType);
        this.connectionProviderDeclarers.put(providerClass, providerDeclarer);
        this.loader.declareFieldBasedParameters((ParameterizedDeclarer)providerDeclarer, providerType.getParameters(), new ParameterDeclarationContext(CONNECTION_PROVIDER, (NamedDeclaration)providerDeclarer.getDeclaration()));
    }
}

