/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.ArrayUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.VoidType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.Ignore;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.runtime.operation.InterceptingCallback;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.runtime.module.extension.internal.introspection.describer.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.model.property.DeclaringMemberModelProperty;
import org.mule.runtime.module.extension.internal.model.property.ImplementingParameterModelProperty;
import org.reflections.ReflectionUtils;
import org.springframework.core.ResolvableType;

public final class IntrospectionUtils {
    private static final String CONFIGURATION = "configuration";
    private static final String OPERATION = "operation";
    private static final String CONNECTION_PROVIDER = "connection provider";
    private static final String SOURCE = "source";

    private IntrospectionUtils() {
    }

    public static MetadataType getMetadataType(Class<?> type, ClassTypeLoader typeLoader) {
        return typeLoader.load(ResolvableType.forClass(type).getType());
    }

    public static MetadataType getMethodReturnType(Method method, ClassTypeLoader typeLoader) {
        ResolvableType methodType = IntrospectionUtils.getMethodType(method);
        Type type = methodType.getType();
        if (methodType.getRawClass().equals(Result.class)) {
            ResolvableType genericType = methodType.getGenerics()[0];
            type = genericType.getRawClass() != null ? genericType.getType() : null;
        }
        return type != null ? typeLoader.load(type) : IntrospectionUtils.typeBuilder().anyType().build();
    }

    public static MetadataType getMethodReturnAttributesType(Method method, ClassTypeLoader typeLoader) {
        ResolvableType genericType;
        Type type = null;
        ResolvableType methodType = IntrospectionUtils.getMethodType(method);
        if (methodType.getRawClass().equals(Result.class) && (genericType = methodType.getGenerics()[1]).getRawClass() != null) {
            type = genericType.getType();
        }
        return type != null ? typeLoader.load(type) : IntrospectionUtils.typeBuilder().voidType().build();
    }

    private static ResolvableType getMethodType(Method method) {
        ResolvableType methodType = IntrospectionUtils.getMethodResolvableType(method);
        if (IntrospectionUtils.isInterceptingCallback(methodType)) {
            methodType = IntrospectionUtils.unwrapGenericFromClass(InterceptingCallback.class, methodType, 0);
        } else if (IntrospectionUtils.isPagingProvider(methodType)) {
            methodType = IntrospectionUtils.unwrapGenericFromClass(PagingProvider.class, methodType, 1);
        }
        return methodType;
    }

    static ResolvableType unwrapGenericFromClass(Class<?> clazz, ResolvableType type, int genericIndex) {
        if (!ArrayUtils.isEmpty((Object[])type.getGenerics())) {
            ResolvableType genericType = type.getGenerics()[genericIndex];
            if (genericType.getRawClass() != null) {
                type = genericType;
            }
        } else {
            if (clazz.isAssignableFrom(type.getRawClass().getSuperclass())) {
                return IntrospectionUtils.unwrapGenericFromClass(clazz, type.getSuperType(), genericIndex);
            }
            ResolvableType interfaceType = Arrays.stream(type.getInterfaces()).filter(i -> clazz.isAssignableFrom(i.getRawClass())).findFirst().orElse(ResolvableType.forType(Object.class));
            return IntrospectionUtils.unwrapGenericFromClass(clazz, interfaceType, genericIndex);
        }
        return type;
    }

    private static boolean isInterceptingCallback(ResolvableType type) {
        return InterceptingCallback.class.isAssignableFrom(type.getRawClass());
    }

    private static boolean isPagingProvider(ResolvableType type) {
        return PagingProvider.class.isAssignableFrom(type.getRawClass());
    }

    private static ResolvableType getMethodResolvableType(Method method) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"Can't introspect a null method");
        return ResolvableType.forMethodReturnType((Method)method);
    }

    private static BaseTypeBuilder typeBuilder() {
        return BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA);
    }

    public static MetadataType[] getMethodArgumentTypes(Method method, ClassTypeLoader typeLoader) {
        Preconditions.checkArgument((method != null ? 1 : 0) != 0, (String)"Can't introspect a null method");
        Object[] parameters = method.getParameterTypes();
        if (ArrayUtils.isEmpty((Object[])parameters)) {
            return new MetadataType[0];
        }
        MetadataType[] types = new MetadataType[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            ResolvableType type = ResolvableType.forMethodParameter((Method)method, (int)i);
            types[i] = typeLoader.load(type.getType());
        }
        return types;
    }

    public static MetadataType getFieldMetadataType(Field field, ClassTypeLoader typeLoader) {
        Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Can't introspect a null field");
        return typeLoader.load(ResolvableType.forField((Field)field).getType());
    }

    public static Optional<Field> getFieldByNameOrAlias(Class<?> clazz, String nameOrAlias) {
        Optional<Field> field = IntrospectionUtils.getField(clazz, nameOrAlias);
        if (!field.isPresent()) {
            field = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{f -> IntrospectionUtils.getAlias(f).equals(nameOrAlias)}).stream().findFirst();
        }
        return field;
    }

    public static Optional<Field> getField(Class<?> clazz, ParameterModel parameterModel) {
        return IntrospectionUtils.getField(clazz, IntrospectionUtils.getMemberName((EnrichableModel)parameterModel, parameterModel.getName()));
    }

    public static Optional<Field> getField(Class<?> clazz, ParameterDeclaration parameterDeclaration) {
        return IntrospectionUtils.getField(clazz, MuleExtensionAnnotationParser.getMemberName(parameterDeclaration, parameterDeclaration.getName()));
    }

    public static Optional<Field> getField(Class<?> clazz, String name) {
        Set candidates = ReflectionUtils.getAllFields(clazz, (Predicate[])new Predicate[]{ReflectionUtils.withName((String)name)});
        return CollectionUtils.isEmpty((Collection)candidates) ? Optional.empty() : Optional.of(candidates.iterator().next());
    }

    public static Object getFieldValue(Object object, String fieldName) throws IllegalAccessException, NoSuchFieldException {
        Optional<Field> fieldOptional = IntrospectionUtils.getField(object.getClass(), fieldName);
        if (fieldOptional.isPresent()) {
            Field field = fieldOptional.get();
            field.setAccessible(true);
            return field.get(object);
        }
        throw new NoSuchFieldException();
    }

    public static String getMemberName(EnrichableModel enrichableModel, String defaultName) {
        return enrichableModel.getModelProperty(DeclaringMemberModelProperty.class).map(p -> p.getDeclaringField().getName()).orElse(defaultName);
    }

    public static boolean hasDefaultConstructor(Class<?> clazz) {
        return ClassUtils.getConstructor(clazz, (Class[])new Class[0]) != null;
    }

    public static List<Class<?>> getInterfaceGenerics(Class<?> type, Class<?> implementedInterface) {
        ResolvableType interfaceType = null;
        Class<?> searchClass = type;
        while (!Object.class.equals(searchClass)) {
            for (ResolvableType iType : ResolvableType.forClass(searchClass).getInterfaces()) {
                if (!implementedInterface.isAssignableFrom(iType.getRawClass())) continue;
                interfaceType = iType;
                break;
            }
            if (interfaceType != null) break;
            searchClass = searchClass.getSuperclass();
        }
        if (interfaceType == null) {
            throw new IllegalArgumentException(String.format("Class '%s' does not implement the '%s' interface", type.getName(), implementedInterface.getName()));
        }
        List<Class<?>> generics = IntrospectionUtils.toRawClasses(interfaceType.getGenerics());
        if (generics.stream().anyMatch(c -> c == null)) {
            return IntrospectionUtils.findGenericsInSuperHierarchy(type);
        }
        return generics;
    }

    public static List<Class<?>> findGenericsInSuperHierarchy(Class<?> type) {
        if (Object.class.equals(type)) {
            return ImmutableList.of();
        }
        Class<?> superClass = type.getSuperclass();
        List<Type> generics = IntrospectionUtils.getSuperClassGenerics(type, superClass);
        if (CollectionUtils.isEmpty(generics) && !Object.class.equals(superClass)) {
            return IntrospectionUtils.findGenericsInSuperHierarchy(superClass);
        }
        return generics;
    }

    private static List<Class<?>> toRawClasses(ResolvableType ... types) {
        return Arrays.stream(types).map(ResolvableType::getRawClass).collect(Collectors.toList());
    }

    public static List<Type> getSuperClassGenerics(Class<?> type, Class<?> superClass) {
        Class<?> searchClass = type;
        Preconditions.checkArgument((boolean)searchClass.getSuperclass().equals(superClass), (String)String.format("Class '%s' does not extend the '%s' class", type.getName(), superClass.getName()));
        while (!Object.class.equals(searchClass)) {
            Type superType;
            if (searchClass.getSuperclass().equals(superClass) && (superType = searchClass.getGenericSuperclass()) instanceof ParameterizedType) {
                return Arrays.stream(((ParameterizedType)superType).getActualTypeArguments()).collect(Collectors.toList());
            }
            searchClass = searchClass.getSuperclass();
        }
        return new LinkedList<Type>();
    }

    public static void checkInstantiable(Class<?> declaringClass) {
        IntrospectionUtils.checkInstantiable(declaringClass, true);
    }

    public static void checkInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor) {
        if (!IntrospectionUtils.isInstantiable(declaringClass, requireDefaultConstructor)) {
            throw new IllegalArgumentException(String.format("Class %s cannot be instantiated.", declaringClass));
        }
    }

    public static boolean isInstantiable(Class<?> declaringClass) {
        return IntrospectionUtils.isInstantiable(declaringClass, true);
    }

    public static boolean isInstantiable(Class<?> declaringClass, boolean requireDefaultConstructor) {
        return declaringClass != null && (!requireDefaultConstructor || IntrospectionUtils.hasDefaultConstructor(declaringClass)) && !declaringClass.isInterface() && !Modifier.isAbstract(declaringClass.getModifiers());
    }

    public static boolean assignableFromAny(Class<?> type, Collection<Class<?>> matchingTypes) {
        return matchingTypes.stream().anyMatch(t -> t.isAssignableFrom(type));
    }

    public static boolean isRequired(AccessibleObject object) {
        return object.getAnnotation(org.mule.runtime.extension.api.annotation.param.Optional.class) == null;
    }

    public static boolean isRequired(ParameterModel parameterModel, boolean forceOptional) {
        return !forceOptional && parameterModel.isRequired();
    }

    public static boolean isVoid(Method method) {
        return IntrospectionUtils.isVoid(method.getReturnType());
    }

    public static boolean isVoid(ComponentModel componentModel) {
        return componentModel.getOutput().getType() instanceof VoidType;
    }

    private static boolean isVoid(Class<?> type) {
        return type.equals(Void.TYPE) || type.equals(Void.class);
    }

    public static Collection<Method> getOperationMethods(Class<?> declaringClass) {
        return IntrospectionUtils.getMethodsStream(declaringClass).filter(method -> !method.isAnnotationPresent(Ignore.class)).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Collection<Method> getMethodsAnnotatedWith(Class<?> declaringClass, Class<? extends Annotation> annotationType) {
        return IntrospectionUtils.getMethodsStream(declaringClass).filter(method -> method.getAnnotation(annotationType) != null).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static Stream<Method> getMethodsStream(Class<?> declaringClass) {
        return ReflectionUtils.getAllSuperTypes(declaringClass, (Predicate[])new Predicate[0]).stream().flatMap(type -> Stream.of(type.getDeclaredMethods())).filter(method -> Modifier.isPublic(method.getModifiers()));
    }

    public static List<Field> getAnnotatedFields(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return (List)IntrospectionUtils.getDescendingHierarchy(clazz).stream().flatMap(type -> Arrays.stream(type.getDeclaredFields())).filter(field -> field.getAnnotation(annotationType) != null).collect(new ImmutableListCollector());
    }

    public static List<Field> getFields(Class<?> clazz) {
        return (List)IntrospectionUtils.getDescendingHierarchy(clazz).stream().flatMap(type -> Arrays.stream(type.getDeclaredFields())).collect(new ImmutableListCollector());
    }

    public static <T extends AnnotatedElement & Member> String getAlias(T element) {
        Alias alias = element.getAnnotation(Alias.class);
        return alias != null ? alias.value() : ((Member)element).getName();
    }

    private static List<Class<?>> getDescendingHierarchy(Class<?> type) {
        LinkedList types = new LinkedList();
        types.add(type);
        for (type = type.getSuperclass(); type != null && !Object.class.equals(type); type = type.getSuperclass()) {
            types.add(0, type);
        }
        return ImmutableList.copyOf(types);
    }

    public static Collection<Field> getExposedFields(Class<?> extensionType) {
        List<Field> allFields = IntrospectionUtils.getAnnotatedFields(extensionType, Parameter.class);
        if (!allFields.isEmpty()) {
            return allFields;
        }
        return IntrospectionUtils.getFieldsWithGetters(extensionType);
    }

    public static Set<Field> getFieldsWithGetters(Class<?> extensionType) {
        return IntrospectionUtils.getPropertyDescriptors(extensionType).stream().filter(p -> p.getReadMethod() != null).map(p -> IntrospectionUtils.getField(extensionType, p.getName())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
    }

    private static List<PropertyDescriptor> getPropertyDescriptors(Class<?> extensionType) {
        try {
            PropertyDescriptor[] propertyDescriptors = Introspector.getBeanInfo(extensionType).getPropertyDescriptors();
            return Arrays.asList(propertyDescriptors);
        }
        catch (IntrospectionException e) {
            throw new IllegalModelDefinitionException("Could not introspect POJO: " + extensionType.getName(), (Throwable)e);
        }
    }

    public static ExpressionSupport getExpressionSupport(AnnotatedElement object) {
        return IntrospectionUtils.getExpressionSupport(object.getAnnotation(Expression.class));
    }

    public static ExpressionSupport getExpressionSupport(Expression expressionAnnotation) {
        return expressionAnnotation != null ? expressionAnnotation.value() : ExpressionSupport.SUPPORTED;
    }

    public static String getSourceName(Class<? extends Source> sourceType) {
        Alias alias = sourceType.getAnnotation(Alias.class);
        if (alias != null) {
            return alias.value();
        }
        return sourceType.getSimpleName();
    }

    public static <T extends Annotation> T getAnnotation(Class<?> annotatedClass, Class<T> annotationClass) {
        T annotation = annotatedClass.getAnnotation(annotationClass);
        for (Class<?> superClass = annotatedClass.getSuperclass(); annotation == null && superClass != null && !superClass.equals(Object.class); superClass = superClass.getSuperclass()) {
            annotation = superClass.getAnnotation(annotationClass);
        }
        return annotation;
    }

    public static Set<Class<?>> getParameterClasses(ExtensionModel extensionModel, final ClassLoader extensionClassLoader) {
        final HashSet parameterClasses = new HashSet();
        new ExtensionWalker(){

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                parameterClasses.addAll(IntrospectionUtils.collectRelativeClasses(model.getType(), extensionClassLoader));
            }
        }.walk(extensionModel);
        return parameterClasses;
    }

    public static Set<Class<?>> collectRelativeClasses(MetadataType type, final ClassLoader extensionClassLoader) {
        final HashSet relativeClasses = new HashSet();
        type.accept(new MetadataTypeVisitor(){

            public void visitDictionary(DictionaryType dictionaryType) {
                dictionaryType.getKeyType().accept((MetadataTypeVisitor)this);
                dictionaryType.getValueType().accept((MetadataTypeVisitor)this);
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitObjectField(ObjectFieldType objectFieldType) {
                objectFieldType.getValue().accept((MetadataTypeVisitor)this);
            }

            public void visitObject(ObjectType objectType) {
                if (!relativeClasses.contains(JavaTypeUtils.getType((MetadataType)objectType))) {
                    Optional classInformation = objectType.getAnnotation(ClassInformationAnnotation.class);
                    if (classInformation.isPresent()) {
                        ((ClassInformationAnnotation)classInformation.get()).getGenericTypes().forEach(generic -> relativeClasses.add(IntrospectionUtils.loadClass(generic, extensionClassLoader)));
                    }
                    relativeClasses.add(JavaTypeUtils.getType((MetadataType)objectType));
                    objectType.getFields().stream().forEach(objectFieldType -> objectFieldType.accept((MetadataTypeVisitor)this));
                }
            }

            public void visitString(StringType stringType) {
                if (MetadataTypeUtils.isEnum((MetadataType)stringType)) {
                    relativeClasses.add(JavaTypeUtils.getType((MetadataType)stringType));
                }
            }
        });
        return relativeClasses;
    }

    private static Class loadClass(String name, ClassLoader extensionClassloader) {
        try {
            return ClassUtils.loadClass((String)name, (ClassLoader)extensionClassloader);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static boolean isMultiLevelMetadataKeyId(Set<Class<? extends Annotation>> annotations, MetadataType parameterType) {
        return annotations.contains(MetadataKeyId.class) && MetadataTypeUtils.isObjectType((MetadataType)parameterType);
    }

    public static boolean isParameterContainer(Set<Class<? extends Annotation>> annotations, MetadataType parameterType) {
        return annotations.contains(ParameterGroup.class) || IntrospectionUtils.isMultiLevelMetadataKeyId(annotations, parameterType);
    }

    public static String getComponentModelTypeName(Object component) {
        if (component instanceof OperationModel) {
            return OPERATION;
        }
        if (component instanceof ConfigurationModel) {
            return CONFIGURATION;
        }
        if (component instanceof ConnectionProviderModel) {
            return CONNECTION_PROVIDER;
        }
        if (component instanceof SourceModel) {
            return SOURCE;
        }
        throw new IllegalArgumentException(String.format("Component '%s' is not an instance of any known model type [%s, %s, %s, %s]", component.toString(), CONFIGURATION, CONNECTION_PROVIDER, OPERATION, SOURCE));
    }

    public static String getComponentDeclarationTypeName(Object component) {
        if (component instanceof OperationDeclaration) {
            return OPERATION;
        }
        if (component instanceof ConfigurationDeclaration) {
            return CONFIGURATION;
        }
        if (component instanceof ConnectionProviderDeclaration) {
            return CONNECTION_PROVIDER;
        }
        if (component instanceof SourceDeclaration) {
            return SOURCE;
        }
        throw new IllegalArgumentException(String.format("Component '%s' is not an instance of any known model type [%s, %s, %s, %s]", component.toString(), CONFIGURATION, CONNECTION_PROVIDER, OPERATION, SOURCE));
    }

    public static String getModelName(Object model) {
        if (model instanceof NamedObject) {
            return ((NamedObject)model).getName();
        }
        throw new IllegalArgumentException(String.format("Model '%s' is not a named type", new Object[0]));
    }

    public static Optional<AnnotatedElement> getAnnotatedElement(BaseDeclaration<?> declaration) {
        Optional declaringMember = declaration.getModelProperty(DeclaringMemberModelProperty.class);
        Optional implementingParameter = declaration.getModelProperty(ImplementingParameterModelProperty.class);
        AnnotatedElement annotatedElement = null;
        if (declaringMember.isPresent()) {
            annotatedElement = ((DeclaringMemberModelProperty)declaringMember.get()).getDeclaringField();
        }
        if (implementingParameter.isPresent()) {
            annotatedElement = ((ImplementingParameterModelProperty)implementingParameter.get()).getParameter();
        }
        return Optional.ofNullable(annotatedElement);
    }
}

