/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithSourcesDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.util.DeclarationWalker;
import org.mule.runtime.api.util.Reference;

public class IdempotentDeclarationWalker
extends DeclarationWalker {
    private Set<Reference<SourceDeclaration>> sources = new HashSet<Reference<SourceDeclaration>>();
    private Set<Reference<ParameterDeclaration>> parameters = new HashSet<Reference<ParameterDeclaration>>();
    private Set<Reference<ParameterGroupDeclaration>> parameterGroups = new HashSet<Reference<ParameterGroupDeclaration>>();
    private Set<Reference<OperationDeclaration>> operations = new HashSet<Reference<OperationDeclaration>>();
    private Set<Reference<ConnectionProviderDeclaration>> connectionProviders = new HashSet<Reference<ConnectionProviderDeclaration>>();

    private <T> boolean isFirstAppearance(Set<Reference<T>> accumulator, T item) {
        return accumulator.add(new Reference(item));
    }

    public void onSource(WithSourcesDeclaration owner, SourceDeclaration declaration) {
        this.doOnce(this.sources, declaration, this::onSource);
    }

    public void onParameterGroup(ParameterizedDeclaration owner, ParameterGroupDeclaration declaration) {
        this.doOnce(this.parameterGroups, declaration, this::onParameterGroup);
    }

    public void onParameter(ParameterizedDeclaration owner, ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
        this.doOnce(this.parameters, declaration, p -> this.onParameter(parameterGroup, declaration));
    }

    public void onOperation(WithOperationsDeclaration owner, OperationDeclaration declaration) {
        this.doOnce(this.operations, declaration, this::onOperation);
    }

    public void onConnectionProvider(ConnectedDeclaration owner, ConnectionProviderDeclaration declaration) {
        this.doOnce(this.connectionProviders, declaration, this::onConnectionProvider);
    }

    private <T> void doOnce(Set<Reference<T>> accumulator, T item, Consumer<T> delegate) {
        if (this.isFirstAppearance(accumulator, item)) {
            delegate.accept(item);
        }
    }

    protected void onConnectionProvider(ConnectionProviderDeclaration declaration) {
    }

    protected void onSource(SourceDeclaration declaration) {
    }

    protected void onParameterGroup(ParameterGroupDeclaration declaration) {
    }

    protected void onParameter(ParameterGroupDeclaration parameterGroup, ParameterDeclaration declaration) {
    }

    protected void onOperation(OperationDeclaration declaration) {
    }
}

