/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Field;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.module.extension.internal.introspection.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.model.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.ParameterGroupObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.util.ValueSetter;
import org.springframework.util.ReflectionUtils;

public final class GroupValueSetter
implements ValueSetter {
    private final ParameterGroupDescriptor groupDescriptor;
    private final Field container;

    public static List<ValueSetter> settersFor(ParameterizedModel model) {
        ImmutableList.Builder setters = ImmutableList.builder();
        model.getParameterGroupModels().stream().filter(group -> !group.getName().equals("General")).forEach(group -> group.getModelProperty(ParameterGroupModelProperty.class).ifPresent(property -> {
            if (property.getDescriptor().getContainer() instanceof Field) {
                setters.add((Object)new GroupValueSetter(property.getDescriptor()));
            }
        }));
        return setters.build();
    }

    public GroupValueSetter(ParameterGroupDescriptor groupDescriptor) {
        this.groupDescriptor = groupDescriptor;
        Preconditions.checkArgument((boolean)(groupDescriptor.getContainer() instanceof Field), (String)"Only field contained parameter groups are allowed");
        this.container = (Field)groupDescriptor.getContainer();
    }

    @Override
    public void set(Object target, ResolverSetResult result) throws MuleException {
        this.container.setAccessible(true);
        ReflectionUtils.setField((Field)this.container, (Object)target, new ParameterGroupObjectBuilder(this.groupDescriptor).build(result));
    }
}

