/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.util;

import java.lang.reflect.Modifier;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.core.util.ValueHolder;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeAliasAnnotation;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ExtensionMetadataTypeUtils {
    private ExtensionMetadataTypeUtils() {
    }

    public static String getAlias(MetadataType metadataType) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? NameUtils.getAliasName((Class)JavaTypeUtils.getType((MetadataType)metadataType)) : "");
    }

    public static String getAlias(MetadataType metadataType, String defaultName) {
        return metadataType.getAnnotation(TypeAliasAnnotation.class).map(TypeAliasAnnotation::getValue).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? NameUtils.getAliasName((String)defaultName, (Alias)JavaTypeUtils.getType((MetadataType)metadataType).getAnnotation(Alias.class)) : defaultName);
    }

    public static boolean isInstantiable(MetadataType metadataType) {
        try {
            return metadataType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isInstantiable).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && IntrospectionUtils.isInstantiable(JavaTypeUtils.getType((MetadataType)metadataType)));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isFinal(MetadataType metadataType) {
        try {
            return metadataType.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::isFinal).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) && Modifier.isFinal(JavaTypeUtils.getType((MetadataType)metadataType).getModifiers()));
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String getId(MetadataType metadataType) {
        try {
            return MetadataTypeUtils.getTypeId((MetadataType)metadataType).orElse(metadataType.getMetadataFormat().equals((Object)MetadataFormat.JAVA) ? JavaTypeUtils.getType((MetadataType)metadataType).getName() : "");
        }
        catch (Exception e) {
            return "";
        }
    }

    public static boolean isBasic(MetadataType type) {
        final ValueHolder basic = new ValueHolder((Object)false);
        type.accept((MetadataTypeVisitor)new BasicTypeMetadataVisitor(){

            protected void visitBasicType(MetadataType metadataType) {
                basic.set((Object)true);
            }
        });
        return (Boolean)basic.get();
    }
}

