/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.transformer.MessageTransformer;
import org.mule.runtime.core.api.transformer.Transformer;
import org.mule.runtime.core.api.transformer.TransformerException;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.util.AttributeEvaluator;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class TypeSafeExpressionValueResolver<T>
implements ValueResolver<T> {
    private final Class<?> expectedType;
    private final AttributeEvaluator evaluator;
    private final MuleContext muleContext;
    private boolean evaluatorInitted = false;

    public TypeSafeExpressionValueResolver(String expression, Class<?> expectedType, MuleContext muleContext) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)expression) ? 1 : 0) != 0, (String)"Expression cannot be blank or null");
        Preconditions.checkArgument((expectedType != null ? 1 : 0) != 0, (String)"expected type cannot be null");
        this.expectedType = expectedType;
        this.evaluator = new AttributeEvaluator(expression);
        this.muleContext = muleContext;
    }

    protected void initEvaluator(MuleContext muleContext) {
        if (!this.evaluatorInitted) {
            this.evaluatorInitted = true;
            this.evaluator.initialize(muleContext.getExpressionManager());
        }
    }

    @Override
    public T resolve(Event event) throws MuleException {
        this.initEvaluator(this.muleContext);
        Object evaluated = this.evaluator.resolveValue(event);
        return (T)(evaluated != null ? this.transform(evaluated, event) : null);
    }

    private T transform(T object, Event event) throws MuleException {
        Transformer transformer;
        this.initEvaluator(this.muleContext);
        if (ClassUtils.isInstance(this.expectedType, object)) {
            return object;
        }
        Type expectedClass = this.expectedType;
        if (expectedClass instanceof ParameterizedType) {
            expectedClass = ((ParameterizedType)expectedClass).getRawType();
        }
        DataType sourceDataType = DataType.fromType(object.getClass());
        DataType targetDataType = DataType.fromType(expectedClass);
        try {
            transformer = this.muleContext.getRegistry().lookupTransformer(sourceDataType, targetDataType);
        }
        catch (TransformerException e) {
            throw new MessagingException(I18nMessageFactory.createStaticMessage((String)String.format("Expression '%s' was expected to return a value of type '%s' but a '%s' was found instead and no suitable transformer could be located", this.evaluator.getRawValue(), this.expectedType.getName(), object.getClass().getName())), event, (Throwable)e);
        }
        if (transformer instanceof MessageTransformer) {
            return (T)((MessageTransformer)transformer).transform(object, event);
        }
        return (T)transformer.transform(object);
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    private static interface EvaluatorDelegate {
        public Object resolveValue(Event var1);
    }
}

