/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class ResolverSet
implements ValueResolver<ResolverSetResult> {
    private Map<String, ValueResolver> resolvers = new LinkedHashMap<String, ValueResolver>();
    private boolean dynamic = false;

    public ResolverSet add(String key, ValueResolver resolver) {
        Preconditions.checkArgument((key != null ? 1 : 0) != 0, (String)"key cannot be null");
        Preconditions.checkArgument((resolver != null ? 1 : 0) != 0, (String)"resolver cannot be null");
        if (this.resolvers.put(key, resolver) != null) {
            throw new IllegalStateException("A value was already given for key " + key);
        }
        if (resolver.isDynamic()) {
            this.dynamic = true;
        }
        return this;
    }

    @Override
    public boolean isDynamic() {
        return this.dynamic;
    }

    @Override
    public ResolverSetResult resolve(Event event) throws MuleException {
        ResolverSetResult.Builder builder = ResolverSetResult.newBuilder();
        for (Map.Entry<String, ValueResolver> entry : this.resolvers.entrySet()) {
            builder.add(entry.getKey(), this.resolveValue(entry.getValue(), event));
        }
        return builder.build();
    }

    private Object resolveValue(ValueResolver<?> resolver, Event event) throws MuleException {
        Object value = resolver.resolve(event);
        if (value instanceof ValueResolver) {
            return this.resolveValue((ValueResolver)value, event);
        }
        return value;
    }

    public Map<String, ValueResolver> getResolvers() {
        return ImmutableMap.copyOf(this.resolvers);
    }
}

