/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.function.Function;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;

final class ExpressionFunction<T>
implements Function<Event, T> {
    private final String expression;
    private final MetadataType type;
    private final MuleContext muleContext;

    ExpressionFunction(String expression, MetadataType type, MuleContext muleContext) {
        this.expression = expression;
        this.type = type;
        this.muleContext = muleContext;
    }

    @Override
    public T apply(Event event) {
        try {
            return new TypeSafeExpressionValueResolver(this.expression, JavaTypeUtils.getType((MetadataType)this.type), this.muleContext).resolve(event);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public boolean equals(Object obj) {
        return obj instanceof ExpressionFunction && ((ExpressionFunction)obj).expression.equals(this.expression) && ((ExpressionFunction)obj).type.equals(this.type);
    }
}

