/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.message.MuleEvent;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.metadata.EntityMetadataProvider;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.MetadataKey;
import org.mule.runtime.api.metadata.MetadataKeysContainer;
import org.mule.runtime.api.metadata.MetadataResolvingException;
import org.mule.runtime.api.metadata.descriptor.TypeMetadataDescriptor;
import org.mule.runtime.api.metadata.resolving.MetadataResult;
import org.mule.runtime.core.api.DefaultMuleException;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.policy.OperationPolicyParametersTransformer;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.policy.OperationParametersProcessor;
import org.mule.runtime.core.policy.OperationPolicy;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.core.util.StringUtils;
import org.mule.runtime.dsl.api.component.ComponentIdentifier;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.runtime.module.extension.internal.metadata.EntityMetadataMediator;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.DefaultExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.ExtensionComponent;
import org.mule.runtime.module.extension.internal.runtime.LazyExecutionContext;
import org.mule.runtime.module.extension.internal.runtime.ParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.IllegalOperationException;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationParameterValueResolver;
import org.mule.runtime.module.extension.internal.runtime.operation.ReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.TargetReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.ValueReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.operation.VoidReturnDelegate;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OperationMessageProcessor
extends ExtensionComponent
implements Processor,
EntityMetadataProvider,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(OperationMessageProcessor.class);
    static final String INVALID_TARGET_MESSAGE = "Flow '%s' defines an invalid usage of operation '%s' which uses %s as target";
    private final ExtensionModel extensionModel;
    private final OperationModel operationModel;
    private final ResolverSet resolverSet;
    private final String target;
    private final EntityMetadataMediator entityMetadataMediator;
    private ExecutionMediator executionMediator;
    private OperationExecutor operationExecutor;
    private PolicyManager policyManager;
    protected ReturnDelegate returnDelegate;

    public OperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, ExtensionManagerAdapter extensionManager, PolicyManager policyManager) {
        super(extensionModel, (ComponentModel)operationModel, configurationProvider, extensionManager);
        this.extensionModel = extensionModel;
        this.operationModel = operationModel;
        this.resolverSet = resolverSet;
        this.target = target;
        this.entityMetadataMediator = new EntityMetadataMediator(operationModel);
        this.policyManager = policyManager;
    }

    public Event process(Event event) throws MuleException {
        return (Event)ClassUtils.withContextClassLoader((ClassLoader)this.getExtensionClassLoader(), () -> {
            Optional<ConfigurationInstance> configuration = this.getConfiguration(event);
            ComponentIdentifier operationIdentifier = new ComponentIdentifier.Builder().withName(this.operationModel.getName()).withNamespace(this.extensionModel.getName().toLowerCase()).build();
            Optional policy = this.policyManager.findOperationPolicy(event.getContext().getId(), operationIdentifier);
            Map<String, Object> operationParameters = this.resolverSet.resolve(event).asMap();
            OperationParametersProcessor operationParametersProcessor = () -> operationParameters;
            Processor nextOperation = operationCallEvent -> {
                HashMap<String, Object> parametersMap = new HashMap<String, Object>();
                parametersMap.putAll(operationParameters);
                Optional operationPolicyParametersTransformer = this.policyManager.lookupOperationParametersTransformer(operationIdentifier);
                if (policy.isPresent() && operationPolicyParametersTransformer.isPresent()) {
                    parametersMap.putAll(((OperationPolicyParametersTransformer)operationPolicyParametersTransformer.get()).fromMessageToParameters((Message)operationCallEvent.getMessage()));
                }
                ExecutionContextAdapter<OperationModel> operationContext = this.createExecutionContext(configuration, parametersMap, event);
                MuleEvent muleEvent = this.doProcess(operationCallEvent, operationContext);
                return (Event)muleEvent;
            };
            if (policy.isPresent()) {
                return ((OperationPolicy)policy.get()).process(event, nextOperation, operationParametersProcessor);
            }
            return nextOperation.process(event);
        }, MuleException.class, e -> {
            throw new DefaultMuleException((Throwable)e);
        });
    }

    protected MuleEvent doProcess(Event event, ExecutionContextAdapter operationContext) throws MuleException {
        Object result = this.executeOperation(operationContext, event);
        MuleEvent resultEvent = this.returnDelegate.asReturnValue(result, operationContext);
        return resultEvent;
    }

    private Object executeOperation(ExecutionContextAdapter operationContext, Event event) throws MuleException {
        try {
            return this.executionMediator.execute(this.operationExecutor, operationContext);
        }
        catch (MessagingException e) {
            if (e.getEvent() == null) {
                throw this.wrapInMessagingException(event, e);
            }
            throw e;
        }
        catch (Throwable e) {
            throw this.wrapInMessagingException(event, e);
        }
    }

    private MessagingException wrapInMessagingException(Event event, Throwable e) {
        return new MessagingException(I18nMessageFactory.createStaticMessage((String)e.getMessage()), event, e, (Processor)this);
    }

    private ExecutionContextAdapter<OperationModel> createExecutionContext(Optional<ConfigurationInstance> configuration, Map<String, Object> resolvedParameters, Event event) throws MuleException {
        return new DefaultExecutionContext<OperationModel>(this.extensionModel, configuration, resolvedParameters, this.operationModel, event, this.muleContext);
    }

    @Override
    protected void doInitialise() throws InitialisationException {
        this.returnDelegate = this.createReturnDelegate();
        this.operationExecutor = MuleExtensionUtils.getOperationExecutorFactory(this.operationModel).createExecutor(this.operationModel);
        this.executionMediator = this.createExecutionMediator();
        LifecycleUtils.initialiseIfNeeded((Object)this.operationExecutor, (boolean)true, (MuleContext)this.muleContext);
    }

    private ReturnDelegate createReturnDelegate() {
        if (IntrospectionUtils.isVoid((ComponentModel)this.operationModel)) {
            return VoidReturnDelegate.INSTANCE;
        }
        return !this.isTargetPresent() ? new ValueReturnDelegate(this.muleContext) : new TargetReturnDelegate(this.target, this.muleContext);
    }

    private boolean isTargetPresent() {
        if (StringUtils.isBlank((String)this.target)) {
            return false;
        }
        if (this.target.startsWith("flowVars")) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.flowConstruct.getName(), this.operationModel.getName(), String.format("the '%s' prefix", "flowVars")));
        }
        if (this.muleContext.getExpressionManager().isExpression(this.target)) {
            throw new IllegalOperationException(String.format(INVALID_TARGET_MESSAGE, this.flowConstruct.getName(), this.operationModel.getName(), "an expression"));
        }
        return true;
    }

    @Override
    public void doStart() throws MuleException {
        LifecycleUtils.startIfNeeded((Object)this.operationExecutor);
    }

    @Override
    public void doStop() throws MuleException {
        LifecycleUtils.stopIfNeeded((Object)this.operationExecutor);
    }

    @Override
    public void doDispose() {
        LifecycleUtils.disposeIfNeeded((Object)this.operationExecutor, (Logger)LOGGER);
    }

    public MetadataResult<MetadataKeysContainer> getEntityKeys() throws MetadataResolvingException {
        MetadataContext metadataContext = this.getMetadataContext();
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.entityMetadataMediator.getEntityKeys(metadataContext));
    }

    public MetadataResult<TypeMetadataDescriptor> getEntityMetadata(MetadataKey key) throws MetadataResolvingException {
        MetadataContext metadataContext = this.getMetadataContext();
        return (MetadataResult)ClassUtils.withContextClassLoader((ClassLoader)MuleExtensionUtils.getClassLoader(this.extensionModel), () -> this.entityMetadataMediator.getEntityMetadata(metadataContext, key));
    }

    protected ExecutionMediator createExecutionMediator() {
        return new DefaultExecutionMediator(this.extensionModel, this.operationModel, this.connectionManager, this.muleContext.getErrorTypeRepository());
    }

    @Override
    protected void validateOperationConfiguration(ConfigurationProvider configurationProvider) {
        ConfigurationModel configurationModel = configurationProvider.getConfigurationModel();
        if (!configurationModel.getOperationModel(this.operationModel.getName()).isPresent() && !configurationProvider.getExtensionModel().getOperationModel(this.operationModel.getName()).isPresent()) {
            throw new IllegalOperationException(String.format("Flow '%s' defines an usage of operation '%s' which points to configuration '%s'. The selected config does not support that operation.", this.flowConstruct.getName(), this.operationModel.getName(), configurationProvider.getName()));
        }
    }

    @Override
    protected ParameterValueResolver getParameterValueResolver() {
        Event event = MuleExtensionUtils.getInitialiserEvent(this.muleContext);
        return new OperationParameterValueResolver(new LazyExecutionContext<OperationModel>(this.resolverSet, this.operationModel, this.extensionModel, event));
    }

    public ReactiveProcessor.ProcessingType getProccesingType() {
        return ReactiveProcessor.ProcessingType.BLOCKING;
    }
}

