/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.operation;

import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.processor.InterceptingMessageProcessor;
import org.mule.runtime.core.api.processor.InternalMessageProcessor;
import org.mule.runtime.core.api.processor.MessageProcessorChain;
import org.mule.runtime.core.api.processor.MessageProcessorContainer;
import org.mule.runtime.core.api.processor.MessageProcessorPathElement;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.exception.MessagingException;
import org.mule.runtime.core.policy.PolicyManager;
import org.mule.runtime.core.util.NotificationUtils;
import org.mule.runtime.extension.api.runtime.ConfigurationProvider;
import org.mule.runtime.extension.api.runtime.operation.InterceptingCallback;
import org.mule.runtime.module.extension.internal.manager.ExtensionManagerAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.InterceptingExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.operation.OperationMessageProcessor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterceptingOperationMessageProcessor
extends OperationMessageProcessor
implements InterceptingMessageProcessor,
MessageProcessorContainer {
    private static final Logger LOGGER = LoggerFactory.getLogger(InterceptingOperationMessageProcessor.class);
    private Processor next;

    public InterceptingOperationMessageProcessor(ExtensionModel extensionModel, OperationModel operationModel, ConfigurationProvider configurationProvider, String target, ResolverSet resolverSet, ExtensionManagerAdapter extensionManager, PolicyManager policyManager) {
        super(extensionModel, operationModel, configurationProvider, target, resolverSet, extensionManager, policyManager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Event doProcess(Event event, ExecutionContextAdapter operationContext) throws MuleException {
        Event resultEvent;
        block6: {
            resultEvent = (Event)super.doProcess(event, operationContext);
            InterceptingCallback<?> interceptingCallback = this.getInterceptorCallback(operationContext);
            try {
                if (interceptingCallback.shouldProcessNext()) {
                    LOGGER.debug("Intercepting operation '{}' will proceed to execute intercepted chain", (Object)operationContext.getComponentModel().getName());
                    try {
                        resultEvent = this.processNext(resultEvent, operationContext);
                    }
                    catch (Exception e) {
                        throw this.onException(interceptingCallback, resultEvent, operationContext, e);
                    }
                    this.onSuccess(operationContext, resultEvent, interceptingCallback);
                    break block6;
                }
                LOGGER.debug("Intercepting operation '{}' skipped processing of intercepted chain", (Object)operationContext.getComponentModel().getName());
            }
            finally {
                operationContext.removeVariable("MULE_INTERCEPTING_CALLBACK_PARAM");
                this.onComplete(interceptingCallback, event, operationContext);
            }
        }
        return resultEvent;
    }

    private MuleException onException(InterceptingCallback<?> interceptingCallback, Event event, ExecutionContextAdapter operationContext, Exception exception) {
        block4: {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Intercepting operation '%s' got an exception while processing intercepted chain", operationContext.getComponentModel().getName()), (Throwable)exception);
            }
            try {
                interceptingCallback.onException(exception);
            }
            catch (Exception e) {
                if (!LOGGER.isDebugEnabled()) break block4;
                LOGGER.debug(String.format("Intercepting operation '%s' got an error while processing exception on callback. Original exception will be thrown back to the flow", operationContext.getComponentModel().getName()), (Throwable)e);
            }
        }
        if (exception instanceof MuleException) {
            return (MuleException)((Object)exception);
        }
        return new MessagingException(event, (Throwable)exception, (Processor)this);
    }

    private void onSuccess(ExecutionContextAdapter operationContext, Event resultEvent, InterceptingCallback<?> interceptingCallback) throws MessagingException {
        LOGGER.debug("Intercepting operation '{}' success", (Object)operationContext.getComponentModel().getName());
        try {
            interceptingCallback.onSuccess((Message)resultEvent.getMessage());
        }
        catch (Exception e) {
            throw new MessagingException(I18nMessageFactory.createStaticMessage((String)String.format("Intercepting operation '%s' executed intercepted chain but failed to process the obtained response", operationContext.getComponentModel().getName())), resultEvent, (Throwable)e, (Processor)this);
        }
    }

    private void onComplete(InterceptingCallback<?> interceptingCallback, Event event, ExecutionContextAdapter operationContext) throws MuleException {
        LOGGER.debug("Intercepting operation '{}' completed", (Object)operationContext.getComponentModel().getName());
        try {
            interceptingCallback.onComplete();
        }
        catch (Exception e) {
            throw new MessagingException(I18nMessageFactory.createStaticMessage((String)String.format("Intercepting operation '%s' failed to notify completion", operationContext.getComponentModel().getName())), event, (Throwable)e, (Processor)this);
        }
    }

    private InterceptingCallback<?> getInterceptorCallback(ExecutionContextAdapter<OperationModel> operationContext) {
        InterceptingCallback interceptingCallback = (InterceptingCallback)operationContext.getVariable("MULE_INTERCEPTING_CALLBACK_PARAM");
        if (interceptingCallback == null) {
            throw new IllegalStateException("Could not find callback for intercepting operation " + ((OperationModel)operationContext.getComponentModel()).getName());
        }
        return interceptingCallback;
    }

    private Event processNext(Event interceptedEvent, ExecutionContextAdapter operationContext) throws MuleException {
        if (this.next == null) {
            return interceptedEvent;
        }
        if (interceptedEvent == null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("MuleEvent is null. Next MessageProcessor '{}' will not be invoked.", (Object)this.next.getClass().getName());
            }
            return null;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Invoking next MessageProcessor: '{}'", (Object)this.next.getClass().getName());
        }
        Event resultEvent = this.next.process(interceptedEvent);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Intercepting operation '%s' executed intercepted chain and got the following event back: ", operationContext.getComponentModel().getName(), resultEvent));
        }
        return resultEvent;
    }

    @Override
    protected ExecutionMediator createExecutionMediator() {
        return new InterceptingExecutionMediator(super.createExecutionMediator());
    }

    public void setListener(Processor listener) {
        this.next = listener;
    }

    public void addMessageProcessorPathElements(MessageProcessorPathElement pathElement) {
        if (this.next instanceof InternalMessageProcessor) {
            return;
        }
        if (this.next instanceof MessageProcessorChain) {
            NotificationUtils.addMessageProcessorPathElements((List)((MessageProcessorChain)this.next).getMessageProcessors(), (MessageProcessorPathElement)pathElement.getParent());
        } else if (this.next != null) {
            NotificationUtils.addMessageProcessorPathElements((Processor)this.next, (MessageProcessorPathElement)pathElement.getParent());
        }
    }
}

