/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.config;

import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.module.extension.internal.introspection.utils.ImplicitObjectUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.config.ImplicitConnectionProviderFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class DefaultImplicitConnectionProviderFactory
implements ImplicitConnectionProviderFactory {
    @Override
    public <T> ConnectionProvider<T> createImplicitConnectionProvider(String configName, ExtensionModel extensionModel, ConfigurationModel configurationModel, Event event, MuleContext muleContext) {
        ConnectionProviderModel implicitModel = ImplicitObjectUtils.getFirstImplicit(MuleExtensionUtils.getAllConnectionProviders(extensionModel, configurationModel));
        if (implicitModel == null) {
            throw new IllegalStateException(String.format("Configuration '%s' of extension '%s' does not define a connection provider and none can be created automatically. Please define one.", configName, configurationModel.getName()));
        }
        ResolverSet resolverSet = ImplicitObjectUtils.buildImplicitResolverSet((ParameterizedModel)implicitModel, muleContext);
        ConnectionProviderObjectBuilder builder = new ConnectionProviderObjectBuilder(implicitModel, resolverSet, (ConnectionManagerAdapter)muleContext.getRegistry().get("_muleConnectionManager"));
        builder.setOwnerConfigName(configName);
        try {
            return (ConnectionProvider)builder.build(event);
        }
        catch (MuleException e) {
            throw new MuleRuntimeException((Throwable)e);
        }
    }
}

