/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.execution.ExecutionTemplate;
import org.mule.runtime.core.api.retry.RetryCallback;
import org.mule.runtime.core.api.retry.RetryContext;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.api.transaction.TransactionConfig;
import org.mule.runtime.core.exception.ErrorTypeRepository;
import org.mule.runtime.core.execution.TransactionalExecutionTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.util.ValueHolder;
import org.mule.runtime.core.work.SerialWorkManager;
import org.mule.runtime.extension.api.runtime.ConfigurationInstance;
import org.mule.runtime.extension.api.runtime.ConfigurationStats;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.RetryRequest;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.mule.runtime.extension.api.runtime.operation.OperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.ExecutionMediator;
import org.mule.runtime.module.extension.internal.runtime.InterceptorsExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.InterceptorsRetryRequest;
import org.mule.runtime.module.extension.internal.runtime.OperationExecutionResult;
import org.mule.runtime.module.extension.internal.runtime.config.MutableConfigurationStats;
import org.mule.runtime.module.extension.internal.runtime.exception.ExceptionEnricherManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DefaultExecutionMediator
implements ExecutionMediator {
    public static final SerialWorkManager WORK_MANAGER = new SerialWorkManager();
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultExecutionMediator.class);
    private final ExceptionEnricherManager exceptionEnricherManager;
    private final ConnectionManagerAdapter connectionManager;
    private final ExecutionTemplate<?> defaultExecutionTemplate = callback -> callback.process();

    public DefaultExecutionMediator(ExtensionModel extensionModel, OperationModel operationModel, ConnectionManagerAdapter connectionManager, ErrorTypeRepository typeRepository) {
        this.connectionManager = connectionManager;
        this.exceptionEnricherManager = new ExceptionEnricherManager(extensionModel, (ComponentModel)operationModel, typeRepository);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(OperationExecutor executor, ExecutionContextAdapter context) throws Throwable {
        List<Interceptor> interceptors = this.collectInterceptors(context.getConfiguration(), executor);
        MutableConfigurationStats mutableStats = this.getMutableConfigurationStats(context);
        if (mutableStats != null) {
            mutableStats.addInflightOperation();
        }
        try {
            Object object = this.executeWithRetryPolicy(executor, context, interceptors);
            return object;
        }
        finally {
            if (mutableStats != null) {
                mutableStats.discountInflightOperation();
            }
        }
    }

    private Object executeWithRetryPolicy(OperationExecutor executor, ExecutionContextAdapter context, List<Interceptor> interceptors) throws Throwable {
        RetryPolicyTemplate retryPolicyTemplate = this.getRetryPolicyTemplate(context.getConfiguration());
        ExecutionTemplate executionTemplate = this.getExecutionTemplate(context);
        OperationRetryCallBack connectionRetry = new OperationRetryCallBack(executor, context, interceptors);
        executionTemplate.execute(() -> retryPolicyTemplate.execute((RetryCallback)connectionRetry, (Executor)WORK_MANAGER));
        Throwable exception = connectionRetry.getOperationExecutionResult().getException();
        if (exception != null) {
            throw exception;
        }
        return connectionRetry.getOperationExecutionResult().getOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OperationExecutionResult executeWithInterceptors(OperationExecutor executor, ExecutionContextAdapter context, List<Interceptor> interceptors, ValueHolder<InterceptorsRetryRequest> retryRequestHolder) {
        Throwable exception;
        Object result;
        block6: {
            result = null;
            exception = null;
            InterceptorsExecutionResult beforeExecutionResult = this.before(context, interceptors);
            try {
                if (beforeExecutionResult.isOk()) {
                    result = executor.execute((ExecutionContext)context);
                    this.onSuccess(context, result, interceptors);
                    break block6;
                }
                interceptors = beforeExecutionResult.getExecutedInterceptors();
                throw beforeExecutionResult.getThrowable();
            }
            catch (Throwable e) {
                exception = this.exceptionEnricherManager.processException(e);
                exception = this.onError(context, retryRequestHolder, exception, interceptors);
            }
            finally {
                this.after(context, result, interceptors);
            }
        }
        return new OperationExecutionResult(result, exception, Optional.ofNullable(retryRequestHolder.get()));
    }

    private InterceptorsExecutionResult before(ExecutionContext executionContext, List<Interceptor> interceptors) {
        ArrayList<Interceptor> interceptorList = new ArrayList<Interceptor>();
        try {
            for (Interceptor interceptor : interceptors) {
                interceptorList.add(interceptor);
                interceptor.before(executionContext);
            }
        }
        catch (Exception e) {
            return new InterceptorsExecutionResult(this.exceptionEnricherManager.handleException(e), interceptorList);
        }
        return new InterceptorsExecutionResult(null, interceptorList);
    }

    private void onSuccess(ExecutionContext executionContext, Object result, List<Interceptor> interceptors) {
        this.intercept(interceptors, interceptor -> interceptor.onSuccess(executionContext, result), interceptor -> String.format("Interceptor %s threw exception executing 'onSuccess' phase. Exception will be ignored. Next interceptors (if any)will be executed and the operation's result will be returned", interceptor));
    }

    private Throwable onError(ExecutionContext executionContext, ValueHolder<InterceptorsRetryRequest> retryRequestHolder, Throwable e, List<Interceptor> interceptors) {
        ValueHolder exceptionHolder = new ValueHolder((Object)e);
        this.intercept(interceptors, interceptor -> {
            InterceptorsRetryRequest retryRequest = new InterceptorsRetryRequest((Interceptor)interceptor, (InterceptorsRetryRequest)retryRequestHolder.get());
            retryRequestHolder.set((Object)retryRequest);
            Throwable decoratedException = interceptor.onError(executionContext, (RetryRequest)retryRequest, (Throwable)exceptionHolder.get());
            if (decoratedException != null) {
                exceptionHolder.set((Object)decoratedException);
            }
        }, interceptor -> String.format("Interceptor %s threw exception executing 'onError' phase. Exception will be ignored. Next interceptors (if any)will be executed and the operation's exception will be returned", interceptor));
        return (Throwable)exceptionHolder.get();
    }

    private void after(ExecutionContext executionContext, Object result, List<Interceptor> interceptors) {
        this.intercept(interceptors, interceptor -> interceptor.after(executionContext, result), interceptor -> String.format("Interceptor %s threw exception executing 'after' phase. Exception will be ignored. Next interceptors (if any)will be executed and the operation's result be returned", interceptor));
    }

    private void intercept(List<Interceptor> interceptors, Consumer<Interceptor> closure, Function<Interceptor, String> exceptionMessageFunction) {
        interceptors.forEach(interceptor -> {
            block2: {
                try {
                    closure.accept((Interceptor)interceptor);
                }
                catch (Exception e) {
                    if (!LOGGER.isDebugEnabled()) break block2;
                    LOGGER.debug((String)exceptionMessageFunction.apply((Interceptor)interceptor), (Throwable)e);
                }
            }
        });
    }

    private <T> ExecutionTemplate<T> getExecutionTemplate(ExecutionContextAdapter<OperationModel> context) {
        return context.getTransactionConfig().map(txConfig -> TransactionalExecutionTemplate.createTransactionalExecutionTemplate((MuleContext)context.getMuleContext(), (TransactionConfig)txConfig)).orElse(this.defaultExecutionTemplate);
    }

    private RetryPolicyTemplate getRetryPolicyTemplate(Optional<ConfigurationInstance> configurationInstance) {
        ConnectionProvider connectionProvider;
        Optional connectionProviderOptional = configurationInstance.map(ConfigurationInstance::getConnectionProvider).orElse(Optional.empty());
        if (connectionProviderOptional.isPresent() && ConnectionProviderWrapper.class.isAssignableFrom((connectionProvider = (ConnectionProvider)connectionProviderOptional.get()).getClass())) {
            return ((ConnectionProviderWrapper)connectionProvider).getRetryPolicyTemplate();
        }
        return this.connectionManager.getDefaultRetryPolicyTemplate();
    }

    private MutableConfigurationStats getMutableConfigurationStats(ExecutionContext<ComponentModel> context) {
        ConfigurationStats stats = context.getConfiguration().map(ConfigurationInstance::getStatistics).orElse(null);
        return stats instanceof MutableConfigurationStats ? (MutableConfigurationStats)stats : null;
    }

    private List<Interceptor> collectInterceptors(Optional<ConfigurationInstance> configurationInstance, OperationExecutor executor) {
        LinkedList<Interceptor> accumulator = new LinkedList<Interceptor>();
        configurationInstance.ifPresent(config -> this.collectInterceptors(accumulator, config));
        this.collectInterceptors(accumulator, (Object)executor);
        return accumulator;
    }

    private void collectInterceptors(List<Interceptor> accumulator, Object subject) {
        if (subject instanceof Interceptable) {
            accumulator.addAll(((Interceptable)subject).getInterceptors());
        }
    }

    private class OperationRetryCallBack
    implements RetryCallback {
        private final ExecutionContextAdapter<OperationModel> context;
        private final List<Interceptor> interceptorList;
        private OperationExecutor operationExecutor;
        private OperationExecutionResult operationExecutionResult;

        private OperationRetryCallBack(OperationExecutor operationExecutor, ExecutionContextAdapter context, List<Interceptor> interceptorList) {
            this.operationExecutor = operationExecutor;
            this.context = context;
            this.interceptorList = interceptorList;
        }

        public void doWork(RetryContext retryContext) throws Exception {
            this.operationExecutionResult = (OperationExecutionResult)DefaultExecutionMediator.this.getExecutionTemplate(this.context).execute(() -> DefaultExecutionMediator.this.executeWithInterceptors(this.operationExecutor, this.context, this.interceptorList, (ValueHolder<InterceptorsRetryRequest>)new ValueHolder()));
            if (!this.operationExecutionResult.isOk()) {
                if (this.operationExecutionResult.getRetryRequest().isPresent() && this.operationExecutionResult.getRetryRequest().get().isRetryRequested()) {
                    Throwable throwable = this.operationExecutionResult.getException();
                    if (throwable instanceof Exception) {
                        throw (Exception)throwable;
                    }
                    throw new MuleRuntimeException(throwable);
                }
                retryContext.setFailed(this.operationExecutionResult.getException());
            }
        }

        public String getWorkDescription() {
            StringBuilder description = new StringBuilder(String.format("Extension '%s'", this.context.getExtensionModel().getName()));
            this.context.getConfiguration().ifPresent(conf -> description.append(String.format(" with configuration '%s'", conf.getName())));
            return description.toString();
        }

        public Object getWorkOwner() {
            return this;
        }

        public OperationExecutionResult getOperationExecutionResult() {
            return this.operationExecutionResult;
        }
    }
}

