/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;
import org.mule.runtime.extension.xml.dsl.api.XmlModelUtils;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.model.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ParameterModelValidator
implements ModelValidator {
    private SubTypesMappingContainer subTypesMapping;

    @Override
    public void validate(ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        this.subTypesMapping = this.loadSubtypesMapping(extensionModel);
        final MetadataTypeVisitor visitor = new MetadataTypeVisitor(){
            private Set<MetadataType> visitedClasses = new HashSet<MetadataType>();

            public void visitDictionary(DictionaryType dictionaryType) {
                dictionaryType.getKeyType().accept((MetadataTypeVisitor)this);
                dictionaryType.getValueType().accept((MetadataTypeVisitor)this);
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitObject(ObjectType objectType) {
                if (this.visitedClasses.add((MetadataType)objectType)) {
                    for (ObjectFieldType field : objectType.getFields()) {
                        String fieldName = field.getKey().getName().getLocalPart();
                        if (ParameterModel.RESERVED_NAMES.contains(fieldName)) {
                            throw new IllegalParameterModelDefinitionException(String.format("The field named '%s' [%s] from class [%s] cannot have that name since it is a reserved one", fieldName, ExtensionMetadataTypeUtils.getId(field.getValue()), ExtensionMetadataTypeUtils.getId((MetadataType)objectType)));
                        }
                        if (!ParameterModelValidator.this.supportsGlobalReferences(field)) continue;
                        field.getValue().accept((MetadataTypeVisitor)this);
                    }
                }
            }
        };
        final String extensionModelName = extensionModel.getName();
        new ExtensionWalker(){

            public void onParameter(ParameterizedModel owner, ParameterGroupModel groupModel, ParameterModel model) {
                String ownerName = owner.getName();
                String ownerModelType = IntrospectionUtils.getComponentModelTypeName(owner);
                ParameterModelValidator.this.validateParameter(model, visitor, ownerName, ownerModelType, extensionModelName);
                ParameterModelValidator.this.validateParameterGroup(groupModel);
                ParameterModelValidator.this.validateNameCollisionWithTypes(model, ownerName, ownerModelType, extensionModelName, owner.getAllParameterModels().stream().map(p -> NameUtils.hyphenize((String)p.getName())).collect(Collectors.toList()));
            }
        }.walk(extensionModel);
    }

    private void validateParameter(ParameterModel parameterModel, MetadataTypeVisitor visitor, String ownerName, String ownerModelType, String extensionName) {
        if (ParameterModel.RESERVED_NAMES.contains(parameterModel.getName())) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter in the %s [%s] from the extension [%s] cannot have the name ['%s'] since it is a reserved one", ownerModelType, ownerName, extensionName, parameterModel.getName()));
        }
        if (parameterModel.getType() == null) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] in the %s [%s] from the extension [%s] must provide a type", parameterModel.getName(), ownerModelType, ownerName, extensionName));
        }
        if (parameterModel.isRequired() && parameterModel.getDefaultValue() != null) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] in the %s [%s] from the extension [%s] is required, and must not provide a default value", parameterModel.getName(), ownerModelType, ownerName, extensionName));
        }
        if (this.supportsGlobalReferences(parameterModel) && this.supportsGlobalReferences(parameterModel.getType()) || this.supportsInlineDefinition(parameterModel)) {
            parameterModel.getType().accept(visitor);
            this.validateParameterIsPlural(parameterModel, ownerModelType, ownerName, extensionName);
        }
    }

    private void validateParameterIsPlural(final ParameterModel parameterModel, final String ownerModelType, final String ownerName, final String extensionName) {
        parameterModel.getType().accept(new MetadataTypeVisitor(){

            public void visitArrayType(ArrayType arrayType) {
                if (parameterModel.getName().equals(NameUtils.singularize((String)parameterModel.getName()))) {
                    throw new IllegalParameterModelDefinitionException(String.format("The parameter '%s' in the %s [%s] from the extension [%s] is a collection and its name should be plural", parameterModel.getName(), ownerModelType, ownerName, extensionName));
                }
            }
        });
    }

    private void validateNameCollisionWithTypes(ParameterModel parameterModel, String ownerName, String ownerModelType, String extensionName, List<String> parameterNames) {
        Optional<MetadataType> subTypeWithNameCollision = this.subTypesMapping.getSubTypes(parameterModel.getType()).stream().filter(subtype -> parameterNames.contains(NameUtils.getTopLevelTypeName((MetadataType)subtype))).findFirst();
        if (subTypeWithNameCollision.isPresent()) {
            throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] in the %s [%s] from the extension [%s] can't have the same name as the ClassName or Alias of the declared subType [%s] for parameter [%s]", NameUtils.getTopLevelTypeName((MetadataType)subTypeWithNameCollision.get()), ownerModelType, ownerName, extensionName, JavaTypeUtils.getType((MetadataType)subTypeWithNameCollision.get()).getSimpleName(), parameterModel.getName()));
        }
    }

    private void validateParameterGroup(ParameterGroupModel groupModel) {
        groupModel.getModelProperty(ParameterGroupModelProperty.class).map(ParameterGroupModelProperty::getDescriptor).ifPresent(group -> {
            if (!IntrospectionUtils.isInstantiable(group.getType().getDeclaringClass())) {
                throw new IllegalParameterModelDefinitionException(String.format("The parameter group of type '%s' should be non abstract with a default constructor.", group.getType().getDeclaringClass()));
            }
        });
    }

    private SubTypesMappingContainer loadSubtypesMapping(ExtensionModel extensionModel) {
        return new SubTypesMappingContainer((Collection)extensionModel.getSubTypes());
    }

    private boolean supportsGlobalReferences(MetadataType type) {
        return XmlModelUtils.supportsTopLevelDeclaration((MetadataType)type) && ExtensionMetadataTypeUtils.isInstantiable(type);
    }

    private boolean supportsGlobalReferences(ObjectFieldType field) {
        return field.getAnnotation(XmlHintsAnnotation.class).map(XmlHintsAnnotation::allowsReferences).orElse(true);
    }

    private boolean supportsGlobalReferences(ParameterModel parameter) {
        return parameter.getDslModel().allowsReferences();
    }

    private boolean supportsInlineDefinition(ParameterModel parameter) {
        return parameter.getDslModel().allowsInlineDefinition();
    }
}

