/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.EnrichableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.model.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.model.property.MetadataKeyPartModelProperty;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public class MetadataComponentModelValidator
implements ModelValidator {
    @Override
    public void validate(final ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        if (!(extensionModel instanceof ExtensionModel)) {
            return;
        }
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel model) {
                this.validateComponent((ComponentModel)model);
            }

            public void onSource(HasSourceModels owner, SourceModel model) {
                this.validateComponent((ComponentModel)model);
            }

            private void validateComponent(ComponentModel model) {
                MetadataComponentModelValidator.this.validateMetadataReturnType(extensionModel, model);
                MetadataResolverFactory resolverFactory = MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)model);
                MetadataComponentModelValidator.this.validateMetadataOutputAttributes(model, resolverFactory);
                MetadataComponentModelValidator.this.validateMetadataKeyId(model, resolverFactory);
                MetadataComponentModelValidator.this.validateCategoriesInScope(model, resolverFactory);
            }
        }.walk(extensionModel);
    }

    private void validateMetadataKeyId(final ComponentModel model, MetadataResolverFactory resolverFactory) {
        Optional keyId = model.getModelProperty(MetadataKeyIdModelProperty.class);
        if (keyId.isPresent()) {
            if (resolverFactory.getOutputResolver() instanceof NullMetadataResolver && this.getAllInputResolvers(model, resolverFactory).isEmpty()) {
                throw new IllegalModelDefinitionException(String.format("Component [%s] defines a MetadataKeyId parameter but neither an Output nor Type resolver that makes use of it was defined", model.getName()));
            }
            ((MetadataKeyIdModelProperty)keyId.get()).getType().accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    List parts = model.getAllParameterModels().stream().filter(p -> p.getModelProperty(MetadataKeyPartModelProperty.class).isPresent()).collect(Collectors.toList());
                    List defaultParts = parts.stream().filter(p -> p.getDefaultValue() != null).collect(Collectors.toList());
                    if (!defaultParts.isEmpty() && defaultParts.size() != parts.size()) {
                        throw new IllegalModelDefinitionException(String.format("[%s] type multilevel key defines [%s] MetadataKeyPart with default values, but the type contains [%s] MetadataKeyParts. All the annotated MetadataKeyParts should have a default value if at least one part has a default value.", JavaTypeUtils.getType((MetadataType)objectType).getSimpleName(), defaultParts.size(), parts.size()));
                    }
                }
            });
        } else if (!(resolverFactory.getKeyResolver() instanceof NullMetadataResolver)) {
            throw new IllegalModelDefinitionException(String.format("Component [%s] does not define a MetadataKeyId parameter but a type keys resolver of type [%s] was associated to it", model.getName(), resolverFactory.getKeyResolver().getClass().getName()));
        }
    }

    private void validateMetadataOutputAttributes(ComponentModel component, MetadataResolverFactory resolverFactory) {
        if (MetadataTypeUtils.isVoid((MetadataType)component.getOutputAttributes().getType()) && !(resolverFactory.getOutputAttributesResolver() instanceof NullMetadataResolver)) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' has an attributes metadata resolver defined but it doesn't set any attributes", IntrospectionUtils.getComponentModelTypeName(component), component.getName()));
        }
    }

    private void validateMetadataReturnType(final ExtensionModel extensionModel, final ComponentModel component) {
        if (MuleExtensionUtils.getMetadataResolverFactory((EnrichableModel)component).getOutputResolver() instanceof NullMetadataResolver) {
            component.getOutput().getType().accept(new MetadataTypeVisitor(){

                public void visitObject(ObjectType objectType) {
                    MetadataComponentModelValidator.this.failIfTypeIsObject(component, extensionModel, (MetadataType)objectType);
                }

                public void visitDictionary(DictionaryType dictionaryType) {
                    MetadataComponentModelValidator.this.failIfTypeIsObject(component, extensionModel, dictionaryType.getValueType());
                }

                public void visitArrayType(ArrayType arrayType) {
                    arrayType.getType().accept((MetadataTypeVisitor)this);
                }
            });
        }
    }

    private void validateCategoriesInScope(ComponentModel componentModel, MetadataResolverFactory metadataResolverFactory) {
        ImmutableList.Builder resolvers = ImmutableList.builder().add((Object)metadataResolverFactory.getKeyResolver()).add((Object)metadataResolverFactory.getOutputResolver()).addAll(this.getAllInputResolvers(componentModel, metadataResolverFactory));
        this.validateCategoryNames(componentModel, (NamedTypeResolver[])resolvers.build().toArray((Object[])new NamedTypeResolver[0]));
    }

    private List<InputTypeResolver<Object>> getAllInputResolvers(ComponentModel componentModel, MetadataResolverFactory resolverFactory) {
        return componentModel.getAllParameterModels().stream().map(NamedObject::getName).map(arg_0 -> ((MetadataResolverFactory)resolverFactory).getInputResolver(arg_0)).collect(Collectors.toList());
    }

    private void validateCategoryNames(ComponentModel componentModel, NamedTypeResolver ... resolvers) {
        Arrays.stream(resolvers).filter(r -> org.mule.runtime.core.util.StringUtils.isBlank((String)r.getCategoryName())).findFirst().ifPresent(r -> {
            throw new IllegalModelDefinitionException(String.format("%s '%s' specifies a metadata resolver [%s] which has an empty category name", IntrospectionUtils.getComponentModelTypeName(componentModel), componentModel.getName(), r.getClass().getSimpleName()));
        });
        Set names = Arrays.stream(resolvers).map(NamedTypeResolver::getCategoryName).filter(r -> !r.equals("NullCategory")).collect(Collectors.toSet());
        if (names.size() > 1) {
            throw new IllegalModelDefinitionException(String.format("%s '%s' specifies metadata resolvers that doesn't belong to the same category. The following categories were the ones found [%s]", IntrospectionUtils.getComponentModelTypeName(componentModel), componentModel.getName(), StringUtils.join(names, (String)",")));
        }
    }

    private void failIfTypeIsObject(ComponentModel componentModel, ExtensionModel extensionModel, MetadataType type) {
        if (Object.class.equals((Object)JavaTypeUtils.getType((MetadataType)type))) {
            String componentTypeName = IntrospectionUtils.getComponentModelTypeName(componentModel);
            throw new IllegalModelDefinitionException(String.format("Extension '%s' specifies a/an %s named '%s' with type '%s' as return type. Operations and Sources with return type such as Object or Map (or a collection of any of those) must have defined a not null OutputTypeResolver", extensionModel.getName(), componentTypeName, componentModel.getName(), ExtensionMetadataTypeUtils.getId(type)));
        }
    }
}

