/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.extension.api.declaration.type.TypeUtils;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class ExportedTypesModelValidator
implements ModelValidator {
    @Override
    public void validate(ExtensionModel extensionModel) throws IllegalModelDefinitionException {
        new IdempotentExtensionWalker(){

            public void onOperation(OperationModel model) {
                model.getAllParameterModels().stream().forEach(parameterModel -> ExportedTypesModelValidator.this.validateJavaType((ComponentModel)model, parameterModel.getType()));
                ExportedTypesModelValidator.this.validateJavaType((ComponentModel)model, model.getOutput().getType());
            }

            public void onSource(SourceModel model) {
                ExportedTypesModelValidator.this.validateJavaType((ComponentModel)model, model.getOutput().getType());
            }
        }.walk(extensionModel);
    }

    private void validateJavaType(ComponentModel model, MetadataType type) {
        if (type.getMetadataFormat().equals((Object)MetadataFormat.JAVA)) {
            this.validateParameterFieldsHaveGetters(model, type);
        }
    }

    private void validateParameterFieldsHaveGetters(final ComponentModel model, MetadataType parameterMetadataType) {
        final String componentTypeName = IntrospectionUtils.getComponentModelTypeName(model);
        final Class parameterType = JavaTypeUtils.getType((MetadataType)parameterMetadataType);
        parameterMetadataType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                Collection parameters = objectType.getFields();
                Set fieldsWithGetters = IntrospectionUtils.getFieldsWithGetters(parameterType).stream().map(TypeUtils::getAlias).collect(Collectors.toSet());
                Set parameterWithoutGetters = parameters.stream().map(f -> f.getKey().getName().getLocalPart()).filter(fieldName -> !fieldsWithGetters.contains(fieldName)).collect(Collectors.toSet());
                if (!parameterWithoutGetters.isEmpty()) {
                    throw new IllegalParameterModelDefinitionException(String.format("%s '%s' has an argument or return type of type '%s' which contains fields (%s) that doesn't have the corresponding getter methods or getter methods that doesn't correspond to any of the present fields", componentTypeName, model.getName(), parameterType.getName(), parameterWithoutGetters.stream().collect(Collectors.joining(", "))));
                }
            }
        });
    }
}

