/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.validation;

import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.extension.api.exception.IllegalConfigurationModelDefinitionException;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.model.property.ConfigTypeModelProperty;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class ConfigurationModelValidator
implements ModelValidator {
    @Override
    public void validate(final ExtensionModel model) throws IllegalModelDefinitionException {
        new ExtensionWalker(){

            public void onOperation(HasOperationModels owner, OperationModel operationModel) {
                if (owner instanceof ConfigurationModel) {
                    Class configType = MuleExtensionUtils.getConfigurationFactory((ConfigurationModel)owner).getObjectType();
                    Optional<Class> operationConfigParameterType = operationModel.getModelProperty(ConfigTypeModelProperty.class).map(modelProperty -> JavaTypeUtils.getType((MetadataType)modelProperty.getConfigType()));
                    if (operationConfigParameterType.isPresent() && !operationConfigParameterType.get().isAssignableFrom(configType)) {
                        throw new IllegalConfigurationModelDefinitionException(String.format("Extension '%s' defines operation '%s' which requires a configuration of type '%s'. However, the operation is reachable from configuration '%s' of incompatible type '%s'.", model.getName(), operationModel.getName(), operationConfigParameterType.get().getName(), ((ConfigurationModel)owner).getName(), configType.getName()));
                    }
                }
            }
        }.walk(model);
    }
}

