/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.utils;

import java.util.List;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeExpressionValueResolver;

public final class ImplicitObjectUtils {
    private ImplicitObjectUtils() {
    }

    public static ResolverSet buildImplicitResolverSet(ParameterizedModel parameterizedModel, MuleContext muleContext) {
        ResolverSet resolverSet = new ResolverSet();
        for (ParameterModel parameterModel : parameterizedModel.getAllParameterModels()) {
            Object defaultValue = parameterModel.getDefaultValue();
            if (defaultValue == null) continue;
            resolverSet.add(parameterModel.getName(), new TypeSafeExpressionValueResolver((String)defaultValue, JavaTypeUtils.getType((MetadataType)parameterModel.getType()), muleContext));
        }
        return resolverSet;
    }

    public static <T extends ParameterizedModel> T getFirstImplicit(List<T> models) {
        for (ParameterizedModel model : models) {
            if (!ImplicitObjectUtils.canBeUsedImplicitly(model)) continue;
            return (T)model;
        }
        return null;
    }

    private static boolean canBeUsedImplicitly(ParameterizedModel parameterizedModel) {
        return parameterizedModel.getAllParameterModels().stream().noneMatch(p -> p.isRequired() && p.getDefaultValue() == null);
    }
}

