/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.describer.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.introspection.enricher.AbstractAnnotatedModelEnricher;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public final class SubTypesModelEnricher
extends AbstractAnnotatedModelEnricher {
    private ClassTypeLoader typeLoader;

    public void enrich(DescribingContext describingContext) {
        ExtensionDeclarer declarer = describingContext.getExtensionDeclarer();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        Optional<ImplementingTypeModelProperty> implementingType = this.extractExtensionType((BaseDeclaration<? extends BaseDeclaration>)extensionDeclaration);
        if (!implementingType.isPresent()) {
            return;
        }
        Class<?> type = implementingType.get().getType();
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(type.getClassLoader());
        List<SubTypeMapping> typeMappings = MuleExtensionAnnotationParser.parseRepeatableAnnotation(type, SubTypeMapping.class, c -> ((SubTypesMapping)c).value());
        if (!typeMappings.isEmpty()) {
            this.declareSubTypesMapping(declarer, typeMappings, extensionDeclaration.getName());
        }
    }

    private void declareSubTypesMapping(ExtensionDeclarer declarer, List<SubTypeMapping> typeMappings, String name) {
        if (typeMappings.stream().map(SubTypeMapping::baseType).distinct().collect(Collectors.toList()).size() != typeMappings.size()) {
            throw new IllegalModelDefinitionException(String.format("There should be only one SubtypeMapping for any given base type in extension [%s]. Duplicated base types are not allowed", name));
        }
        typeMappings.forEach(mapping -> declarer.withSubTypes(IntrospectionUtils.getMetadataType(mapping.baseType(), this.typeLoader), (Collection)Arrays.stream(mapping.subTypes()).map(subType -> IntrospectionUtils.getMetadataType(subType, this.typeLoader)).collect(new ImmutableListCollector())));
    }
}

