/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.extension.api.annotation.Import;
import org.mule.runtime.extension.api.annotation.ImportedTypes;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.describer.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.introspection.enricher.AbstractAnnotatedModelEnricher;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;

public final class ImportedTypesModelEnricher
extends AbstractAnnotatedModelEnricher {
    private ClassTypeLoader typeLoader;

    public void enrich(DescribingContext describingContext) {
        ExtensionDeclarer descriptor = describingContext.getExtensionDeclarer();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)descriptor.getDeclaration();
        Optional<ImplementingTypeModelProperty> implementingType = this.extractExtensionType((BaseDeclaration<? extends BaseDeclaration>)extensionDeclaration);
        if (!implementingType.isPresent()) {
            return;
        }
        Class<?> type = implementingType.get().getType();
        this.typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(type.getClassLoader());
        List<Import> importTypes = MuleExtensionAnnotationParser.parseRepeatableAnnotation(type, Import.class, c -> ((ImportedTypes)c).value());
        if (!importTypes.isEmpty()) {
            if (importTypes.stream().map(Import::type).distinct().collect(Collectors.toList()).size() != importTypes.size()) {
                throw new IllegalModelDefinitionException(String.format("There should be only one Import declaration for any given type in extension [%s]. Multiple imports of the same type are not allowed", extensionDeclaration.getName()));
            }
            importTypes.forEach(imported -> extensionDeclaration.addImportedType(new ImportedTypeModel(imported.from(), this.typeLoader.load((Type)imported.type()))));
        }
    }
}

