/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.mule.runtime.api.meta.model.ElementDslModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;

public class ContentParameterModelEnricher
implements ModelEnricher {
    public void enrich(DescribingContext describingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onOperation(OperationDeclaration declaration) {
                ContentParameterModelEnricher.this.doEnrich((ParameterizedDeclaration)declaration);
            }

            @Override
            protected void onSource(SourceDeclaration declaration) {
                ContentParameterModelEnricher.this.doEnrich((ParameterizedDeclaration)declaration);
            }
        }.walk((ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration());
    }

    private void doEnrich(ParameterizedDeclaration declaration) {
        List<ParameterDeclaration> contentParameters = this.getContentParameters(declaration.getAllParameters());
        if (CollectionUtils.isEmpty(contentParameters)) {
            return;
        }
        if (contentParameters.size() == 1) {
            contentParameters.get(0).setParameterRole(ParameterRole.PRIMARY_CONTENT);
        }
        contentParameters.forEach(p -> {
            this.configureDsl((ParameterDeclaration)p);
            if (p.getRole() == ParameterRole.PRIMARY_CONTENT) {
                this.defaultToPayload((ParameterDeclaration)p);
                p.setRequired(false);
            }
        });
    }

    private void configureDsl(ParameterDeclaration p) {
        p.setDslModel(ElementDslModel.builder((ElementDslModel)p.getDslModel()).allowsReferences(false).allowsInlineDefinition(true).build());
    }

    private void defaultToPayload(ParameterDeclaration p) {
        p.setRequired(false);
        p.setDefaultValue((Object)"#[payload]");
    }

    private List<ParameterDeclaration> getContentParameters(List<ParameterDeclaration> parameters) {
        return parameters.stream().filter(p -> p.getRole() != ParameterRole.BEHAVIOUR).collect(Collectors.toList());
    }
}

