/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.enricher;

import java.util.Optional;
import java.util.Set;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOperationsDeclaration;
import org.mule.runtime.api.meta.model.error.ErrorModel;
import org.mule.runtime.extension.api.annotation.error.ErrorTypes;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.model.property.ConnectivityModelProperty;
import org.mule.runtime.module.extension.internal.introspection.describer.model.runtime.ExtensionTypeWrapper;
import org.mule.runtime.module.extension.internal.introspection.enricher.ModuleErrors;
import org.mule.runtime.module.extension.internal.model.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.util.IdempotentDeclarationWalker;

public class ConnectionErrorsModelEnricher
implements ModelEnricher {
    private static final String MULE_NAMESPACE = "mule".toUpperCase();

    public void enrich(DescribingContext describingContext) {
        ExtensionDeclaration declaration = (ExtensionDeclaration)describingContext.getExtensionDeclarer().getDeclaration();
        Optional implementingType = declaration.getModelProperty(ImplementingTypeModelProperty.class);
        if (implementingType.isPresent()) {
            ExtensionTypeWrapper extensionElement = new ExtensionTypeWrapper(((ImplementingTypeModelProperty)implementingType.get()).getType());
            extensionElement.getAnnotation(ErrorTypes.class).ifPresent(errorTypesAnnotation -> {
                final Set errorModels = declaration.getErrorModels();
                if (!errorModels.isEmpty()) {
                    new IdempotentDeclarationWalker(){

                        @Override
                        public void onOperation(WithOperationsDeclaration owner, OperationDeclaration operation) {
                            if (operation.getModelProperty(ConnectivityModelProperty.class).isPresent()) {
                                operation.addError(ConnectionErrorsModelEnricher.this.getErrorModel(ModuleErrors.CONNECTIVITY, errorModels, operation));
                                operation.addError(ConnectionErrorsModelEnricher.this.getErrorModel(ModuleErrors.RETRY_EXHAUSTED, errorModels, operation));
                            }
                        }
                    }.walk(declaration);
                }
            });
        }
    }

    private ErrorModel getErrorModel(ErrorTypeDefinition<?> errorTypeDefinition, Set<ErrorModel> errorModels, OperationDeclaration operation) {
        return errorModels.stream().filter(error -> !error.getNamespace().equals(MULE_NAMESPACE) && error.getType().equals(errorTypeDefinition.getType())).findFirst().orElseThrow(() -> new IllegalModelDefinitionException(String.format("Trying to add the '%s' Error to the Component '%s' but the Extension doesn't declare it", errorTypeDefinition, operation.getName())));
    }
}

