/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection.describer.contributor;

import java.util.Optional;
import java.util.function.Function;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.utils.JavaTypeUtils;
import org.mule.runtime.api.meta.model.ElementDslModel;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.util.ClassUtils;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.module.extension.internal.introspection.describer.FunctionParameterTypeModelProperty;
import org.mule.runtime.module.extension.internal.introspection.describer.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.introspection.describer.model.ExtensionParameter;
import org.mule.runtime.module.extension.internal.introspection.utils.ParameterDeclarationContext;

public class FunctionParameterTypeContributor
implements ParameterDeclarerContributor {
    private ClassTypeLoader typeLoader;

    public FunctionParameterTypeContributor(ClassTypeLoader typeLoader) {
        this.typeLoader = typeLoader;
    }

    @Override
    public void contribute(ExtensionParameter parameter, ParameterDeclarer declarer, ParameterDeclarationContext declarationContext) {
        Optional eventType;
        MetadataType metadataType = parameter.getMetadataType(this.typeLoader);
        if (Function.class.isAssignableFrom(parameter.getType().getDeclaringClass()) && (eventType = JavaTypeUtils.getGenericTypeAt((MetadataType)metadataType, (int)0, (ClassTypeLoader)this.typeLoader)).isPresent() && this.isEventType((MetadataType)eventType.get())) {
            Optional expressionType = JavaTypeUtils.getGenericTypeAt((MetadataType)metadataType, (int)1, (ClassTypeLoader)this.typeLoader);
            if (!expressionType.isPresent()) {
                throw new IllegalParameterModelDefinitionException(String.format("The parameter [%s] from the %s [%s] doesn't specify the %s parameterized types: Function<Event,{Type}>", parameter.getName(), declarationContext.getComponentType(), declarationContext.getName(), Function.class.getSimpleName()));
            }
            metadataType = (MetadataType)expressionType.get();
            declarer.ofType(metadataType);
            declarer.withModelProperty((ModelProperty)new FunctionParameterTypeModelProperty());
            declarer.withDsl(ElementDslModel.builder().allowsInlineDefinition(false).allowsReferences(true).allowTopLevelDefinition(false).build());
        }
    }

    private boolean isEventType(MetadataType eventType) {
        Optional typeId = MetadataTypeUtils.getTypeId((MetadataType)eventType);
        if (typeId.isPresent()) {
            try {
                return ClassUtils.getClass((String)((String)typeId.get())).equals(Event.class);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return false;
    }
}

