/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.OutputModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OutputDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterGroupDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.util.CollectionUtils;
import org.mule.runtime.core.util.collection.ImmutableListCollector;
import org.mule.runtime.extension.api.declaration.DescribingContext;
import org.mule.runtime.extension.api.declaration.spi.ModelEnricher;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.model.ImmutableExtensionModel;
import org.mule.runtime.extension.api.model.ImmutableOutputModel;
import org.mule.runtime.extension.api.model.config.ImmutableConfigurationModel;
import org.mule.runtime.extension.api.model.connection.ImmutableConnectionProviderModel;
import org.mule.runtime.extension.api.model.operation.ImmutableOperationModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableExclusiveParametersModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterGroupModel;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.model.source.ImmutableSourceModel;
import org.mule.runtime.extension.api.runtime.ExtensionFactory;
import org.mule.runtime.module.extension.internal.introspection.validation.ConfigurationModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ConnectionProviderModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ConnectionProviderNameModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ContentParameterModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ExclusiveParameterModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ExportedTypesModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.MetadataComponentModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.NameClashModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.OperationParametersModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.OperationReturnTypeModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.ParameterModelValidator;
import org.mule.runtime.module.extension.internal.introspection.validation.SubtypesModelValidator;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;

public final class DefaultExtensionFactory
implements ExtensionFactory {
    private final List<ModelEnricher> modelEnrichers;
    private final List<ModelValidator> modelValidators;

    public DefaultExtensionFactory(ServiceRegistry serviceRegistry, ClassLoader classLoader) {
        this.modelEnrichers = ImmutableList.copyOf((Collection)serviceRegistry.lookupProviders(ModelEnricher.class, classLoader));
        this.modelValidators = ImmutableList.builder().add((Object)new SubtypesModelValidator()).add((Object)new NameClashModelValidator()).add((Object)new ParameterModelValidator()).add((Object)new ExportedTypesModelValidator()).add((Object)new ConnectionProviderModelValidator()).add((Object)new ConfigurationModelValidator()).add((Object)new OperationReturnTypeModelValidator()).add((Object)new OperationParametersModelValidator()).add((Object)new MetadataComponentModelValidator()).add((Object)new ExclusiveParameterModelValidator()).add((Object)new ConnectionProviderNameModelValidator()).add((Object)new ContentParameterModelValidator()).build();
    }

    public ExtensionModel createFrom(ExtensionDeclarer declarer, DescribingContext describingContext) {
        this.enrichModel(describingContext);
        ExtensionModel extensionModel = new FactoryDelegate().toExtension((ExtensionDeclaration)declarer.getDeclaration());
        this.modelValidators.forEach(v -> v.validate(extensionModel));
        return extensionModel;
    }

    private void validateMuleVersion(ExtensionDeclaration extensionDeclaration) {
        try {
            new MuleVersion(extensionDeclaration.getVersion());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(String.format("Invalid version '%s' for extension '%s'", extensionDeclaration.getVersion(), extensionDeclaration.getName()));
        }
    }

    private void enrichModel(DescribingContext describingContext) {
        this.modelEnrichers.forEach(enricher -> enricher.enrich(describingContext));
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private class FactoryDelegate {
        private Cache<ParameterizedDeclaration, ParameterizedModel> modelCache = CacheBuilder.newBuilder().build();

        private FactoryDelegate() {
        }

        private ExtensionModel toExtension(ExtensionDeclaration extensionDeclaration) {
            DefaultExtensionFactory.this.validateMuleVersion(extensionDeclaration);
            ImmutableExtensionModel extensionModel = new ImmutableExtensionModel(extensionDeclaration.getName(), extensionDeclaration.getDescription(), extensionDeclaration.getVersion(), extensionDeclaration.getVendor(), extensionDeclaration.getCategory(), extensionDeclaration.getMinMuleVersion(), this.sortConfigurations(this.toConfigurations(extensionDeclaration.getConfigurations())), this.toOperations(extensionDeclaration.getOperations()), this.toConnectionProviders(extensionDeclaration.getConnectionProviders()), this.toMessageSources(extensionDeclaration.getMessageSources()), extensionDeclaration.getDisplayModel(), extensionDeclaration.getXmlDslModel(), extensionDeclaration.getSubTypes(), extensionDeclaration.getTypes(), extensionDeclaration.getImportedTypes(), extensionDeclaration.getErrorModels(), extensionDeclaration.getModelProperties());
            return extensionModel;
        }

        private List<ConfigurationModel> sortConfigurations(List<ConfigurationModel> configurationModels) {
            if (CollectionUtils.isEmpty(configurationModels)) {
                return configurationModels;
            }
            return MuleExtensionUtils.alphaSortDescribedList(configurationModels);
        }

        private List<ConfigurationModel> toConfigurations(List<ConfigurationDeclaration> declarations) {
            return declarations.stream().map(this::toConfiguration).collect(Collectors.toList());
        }

        private <T extends ParameterizedModel> T fromCache(ParameterizedDeclaration declaration, Supplier<ParameterizedModel> supplier) {
            try {
                return (T)((ParameterizedModel)this.modelCache.get((Object)declaration, supplier::get));
            }
            catch (UncheckedExecutionException e) {
                if (e.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw e;
            }
            catch (ExecutionException e) {
                throw new MuleRuntimeException((Throwable)e);
            }
        }

        private ConfigurationModel toConfiguration(ConfigurationDeclaration declaration) {
            return (ConfigurationModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableConfigurationModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toOperations(declaration.getOperations()), this.toConnectionProviders(declaration.getConnectionProviders()), this.toMessageSources(declaration.getMessageSources()), declaration.getDisplayModel(), declaration.getModelProperties()));
        }

        private List<SourceModel> toMessageSources(List<SourceDeclaration> declarations) {
            return MuleExtensionUtils.alphaSortDescribedList(declarations.stream().map(this::toMessageSource).collect(Collectors.toList()));
        }

        private SourceModel toMessageSource(SourceDeclaration declaration) {
            return (SourceModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableSourceModel(declaration.getName(), declaration.getDescription(), declaration.hasResponse(), this.toParameterGroups(declaration.getParameterGroups()), this.toOutputModel(declaration.getOutput()), this.toOutputModel(declaration.getOutputAttributes()), declaration.getDisplayModel(), declaration.getModelProperties()));
        }

        private List<OperationModel> toOperations(List<OperationDeclaration> declarations) {
            return MuleExtensionUtils.alphaSortDescribedList(declarations.stream().map(this::toOperation).collect(Collectors.toList()));
        }

        private OperationModel toOperation(OperationDeclaration declaration) {
            return (OperationModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableOperationModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), this.toOutputModel(declaration.getOutput()), this.toOutputModel(declaration.getOutputAttributes()), declaration.getDisplayModel(), declaration.getErrorModels(), declaration.getModelProperties()));
        }

        private List<ConnectionProviderModel> toConnectionProviders(List<ConnectionProviderDeclaration> declarations) {
            return (List)declarations.stream().map(this::toConnectionProvider).collect(new ImmutableListCollector());
        }

        private OutputModel toOutputModel(OutputDeclaration declaration) {
            return declaration != null ? new ImmutableOutputModel(declaration.getDescription(), declaration.getType(), declaration.hasDynamicType(), declaration.getModelProperties()) : new ImmutableOutputModel("", (MetadataType)BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).voidType().build(), false, Collections.emptySet());
        }

        private ConnectionProviderModel toConnectionProvider(ConnectionProviderDeclaration declaration) {
            return (ConnectionProviderModel)this.fromCache((ParameterizedDeclaration)declaration, () -> new ImmutableConnectionProviderModel(declaration.getName(), declaration.getDescription(), this.toParameterGroups(declaration.getParameterGroups()), declaration.getConnectionManagementType(), declaration.getDisplayModel(), declaration.getModelProperties()));
        }

        private List<ParameterGroupModel> toParameterGroups(List<ParameterGroupDeclaration> declarations) {
            if (declarations.isEmpty()) {
                return ImmutableList.of();
            }
            declarations = new ArrayList<ParameterGroupDeclaration>(declarations);
            declarations.sort((left, right) -> {
                if ("General".equals(left.getName())) {
                    return -1;
                }
                if ("General".equals(right.getName())) {
                    return 1;
                }
                return 0;
            });
            return (List)declarations.stream().map(this::toParameterGroup).collect(new ImmutableListCollector());
        }

        private ParameterGroupModel toParameterGroup(ParameterGroupDeclaration declaration) {
            return new ImmutableParameterGroupModel(declaration.getName(), declaration.getDescription(), this.toParameters(declaration.getParameters()), this.toExclusiveParametersModels(declaration), declaration.getDisplayModel(), declaration.getLayoutModel(), declaration.getModelProperties());
        }

        private List<ExclusiveParametersModel> toExclusiveParametersModels(ParameterGroupDeclaration groupDeclaration) {
            return (List)groupDeclaration.getExclusiveParameters().stream().map(exclusive -> new ImmutableExclusiveParametersModel(exclusive.getParameterNames(), exclusive.isRequiresOne())).collect(new ImmutableListCollector());
        }

        private List<ParameterModel> toParameters(List<ParameterDeclaration> declarations) {
            if (declarations.isEmpty()) {
                return ImmutableList.of();
            }
            return (List)declarations.stream().map(this::toParameter).collect(new ImmutableListCollector());
        }

        private ParameterModel toParameter(ParameterDeclaration parameter) {
            Object defaultValue = parameter.getDefaultValue();
            if (defaultValue instanceof String) {
                if (parameter.getExpressionSupport() == ExpressionSupport.NOT_SUPPORTED && DefaultExtensionFactory.this.isExpression((String)defaultValue)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' is marked as not supporting expressions yet it contains one as a default value. Please fix this", parameter.getName()));
                }
                if (parameter.getExpressionSupport() == ExpressionSupport.REQUIRED && !DefaultExtensionFactory.this.isExpression((String)defaultValue)) {
                    throw new IllegalParameterModelDefinitionException(String.format("Parameter '%s' requires expressions yet it contains a constant as a default value. Please fix this", parameter.getName()));
                }
            }
            return new ImmutableParameterModel(parameter.getName(), parameter.getDescription(), parameter.getType(), parameter.hasDynamicType(), parameter.isRequired(), parameter.getExpressionSupport(), parameter.getDefaultValue(), parameter.getRole(), parameter.getDslModel(), parameter.getDisplayModel(), parameter.getLayoutModel(), parameter.getModelProperties());
        }
    }
}

