/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.introspection;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.runtime.Interceptable;
import org.mule.runtime.extension.api.runtime.operation.Interceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInterceptable
implements Interceptable,
Lifecycle {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractInterceptable.class);
    private final List<Interceptor> interceptors;
    @Inject
    protected MuleContext muleContext;

    public AbstractInterceptable(List<Interceptor> interceptors) {
        this.interceptors = interceptors != null ? ImmutableList.copyOf(interceptors) : ImmutableList.of();
    }

    public void initialise() throws InitialisationException {
        for (Interceptor interceptor : this.interceptors) {
            LifecycleUtils.initialiseIfNeeded((Object)interceptor, (boolean)true, (MuleContext)this.muleContext);
        }
    }

    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.interceptors);
    }

    public void stop() throws MuleException {
        LifecycleUtils.safeStopIfNeeded(this.interceptors, (Logger)LOGGER);
    }

    public void dispose() {
        LifecycleUtils.disposeIfNeeded(this.interceptors, (Logger)LOGGER);
    }

    public final List<Interceptor> getInterceptors() {
        return this.interceptors;
    }
}

