/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.extension.api.declaration.DescribingContext;

public final class DefaultDescribingContext
implements DescribingContext {
    private final ExtensionDeclarer extensionDeclarer;
    private final Map<String, Object> customParameters = new HashMap<String, Object>();

    public DefaultDescribingContext(ClassLoader classLoader) {
        this(new ExtensionDeclarer(), classLoader);
    }

    public DefaultDescribingContext(ExtensionDeclarer extensionDeclarer, ClassLoader classLoader) {
        this.extensionDeclarer = extensionDeclarer;
        this.addParameter("extension_classloader", classLoader);
    }

    public ExtensionDeclarer getExtensionDeclarer() {
        return this.extensionDeclarer;
    }

    public void addParameter(String key, Object value) {
        Preconditions.checkArgument((!StringUtils.isBlank((String)key) ? 1 : 0) != 0, (String)"key cannot be blank");
        Preconditions.checkArgument((value != null ? 1 : 0) != 0, (String)"value cannot be null");
        this.customParameters.put(key, value);
    }

    public <T> T getParameter(String key, Class<T> expectedType) {
        Object parameter = this.customParameters.get(key);
        if (parameter == null) {
            return null;
        }
        if (!expectedType.isInstance(parameter)) {
            throw new IllegalArgumentException(String.format("Custom parameter '%s' was expected to be of class '%s' but got '%s' instead", key, expectedType.getName(), parameter.getClass().getName()));
        }
        return (T)parameter;
    }
}

