/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.parameter;

import java.lang.reflect.Type;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.config.dsl.parameter.TopLevelParameterObjectFactory;
import org.mule.runtime.module.extension.internal.loader.ParameterGroupDescriptor;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;

public class ParameterGroupParser
extends ExtensionDefinitionParser {
    private final ParameterGroupModel group;
    private final ClassLoader classLoader;
    private final DslElementSyntax groupDsl;
    private final String name;
    private final String namespace;
    private final ParameterGroupDescriptor groupDescriptor;
    private final MetadataType metadataType;

    public ParameterGroupParser(ComponentBuildingDefinition.Builder definition, ParameterGroupModel group, ParameterGroupDescriptor groupDescriptor, ClassLoader classLoader, DslElementSyntax groupDsl, DslSyntaxResolver dslResolver, ExtensionParsingContext context, MuleContext muleContext) {
        super(definition, dslResolver, context, muleContext);
        Preconditions.checkArgument((boolean)group.isShowInDsl(), (String)"Cannot parse an implicit group");
        this.group = group;
        this.groupDescriptor = groupDescriptor;
        this.classLoader = classLoader;
        this.groupDsl = groupDsl;
        this.name = groupDsl.getElementName();
        this.namespace = groupDsl.getNamespace();
        this.metadataType = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader(classLoader).load((Type)groupDescriptor.getType().getDeclaringClass());
    }

    @Override
    protected void doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        definitionBuilder.withIdentifier(this.name).withNamespace(this.namespace).asNamed().withTypeDefinition(TypeDefinition.fromType(ValueResolver.class)).withObjectFactoryType(TopLevelParameterObjectFactory.class).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.metadataType).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.classLoader).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue((Object)this.muleContext).build());
        this.parseParameters(this.group.getParameterModels());
    }
}

