/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.dsl.connection;

import org.mule.runtime.api.config.PoolingProfile;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.registry.RegistrationException;
import org.mule.runtime.core.api.retry.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.ConnectionManagerAdapter;
import org.mule.runtime.module.extension.internal.config.dsl.AbstractExtensionObjectFactory;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;

public class ConnectionProviderObjectFactory
extends AbstractExtensionObjectFactory<ConnectionProviderResolver> {
    private final ConnectionProviderModel providerModel;
    private final ExtensionModel extensionModel;
    private PoolingProfile poolingProfile = null;
    private RetryPolicyTemplate retryPolicyTemplate = null;
    private boolean disableValidation = false;

    public ConnectionProviderObjectFactory(ConnectionProviderModel providerModel, MuleContext muleContext, ExtensionModel extensionModel) {
        super(muleContext);
        this.providerModel = providerModel;
        this.extensionModel = extensionModel;
    }

    public ConnectionProviderResolver doGetObject() throws Exception {
        ResolverSet resolverSet = this.parametersResolver.getParametersAsResolverSet((ParameterizedModel)this.providerModel);
        return new ConnectionProviderResolver(new ConnectionProviderObjectBuilder(this.providerModel, resolverSet, this.poolingProfile, this.disableValidation, this.retryPolicyTemplate, this.getConnectionManager(), this.extensionModel, this.muleContext), resolverSet);
    }

    private ConnectionManagerAdapter getConnectionManager() throws ConfigurationException {
        try {
            return (ConnectionManagerAdapter)this.muleContext.getRegistry().lookupObject(ConnectionManagerAdapter.class);
        }
        catch (RegistrationException e) {
            throw new ConfigurationException(I18nMessageFactory.createStaticMessage((String)"Could not obtain connection manager adapter form registry"), (Throwable)e);
        }
    }

    public void setPoolingProfile(PoolingProfile poolingProfile) {
        this.poolingProfile = poolingProfile;
    }

    public void setRetryPolicyTemplate(RetryPolicyTemplate retryPolicyTemplate) {
        this.retryPolicyTemplate = retryPolicyTemplate;
    }

    public void setDisableValidation(boolean disableValidation) {
        this.disableValidation = disableValidation;
    }
}

