/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.extension.internal.resources;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.mule.api.registry.ServiceRegistry;
import org.mule.extension.annotations.Extension;
import org.mule.extension.introspection.ExtensionFactory;
import org.mule.extension.introspection.declaration.DescribingContext;
import org.mule.extension.introspection.declaration.fluent.Descriptor;
import org.mule.module.extension.internal.DefaultDescribingContext;
import org.mule.module.extension.internal.capability.xml.schema.AnnotationProcessorUtils;
import org.mule.module.extension.internal.introspection.AnnotationsBasedDescriber;
import org.mule.module.extension.internal.introspection.DefaultExtensionFactory;
import org.mule.module.extension.internal.resources.AnnotationProcessorResourceGenerator;
import org.mule.registry.SpiServiceRegistry;
import org.mule.util.ExceptionUtils;

@SupportedAnnotationTypes(value={"org.mule.extension.annotations.Extension"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class ExtensionResourcesGeneratorAnnotationProcessor
extends AbstractProcessor {
    public static final String PROCESSING_ENVIRONMENT = "PROCESSING_ENVIRONMENT";
    public static final String EXTENSION_ELEMENT = "EXTENSION_ELEMENT";
    public static final String ROUND_ENVIRONMENT = "ROUND_ENVIRONMENT";
    private final ExtensionFactory extensionFactory = new DefaultExtensionFactory((ServiceRegistry)new SpiServiceRegistry());

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        this.log("Starting Resources generator for Extensions");
        AnnotationProcessorResourceGenerator generator = new AnnotationProcessorResourceGenerator(this.processingEnv, (ServiceRegistry)new SpiServiceRegistry());
        try {
            for (TypeElement extensionElement : this.findExtensions(roundEnv)) {
                org.mule.extension.introspection.Extension extension = this.parseExtension(extensionElement, roundEnv);
                generator.generateFor(extension);
            }
            generator.dumpAll();
            return false;
        }
        catch (Exception e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, String.format("%s\n%s", e.getMessage(), ExceptionUtils.getFullStackTrace((Throwable)e)));
            throw e;
        }
    }

    private org.mule.extension.introspection.Extension parseExtension(TypeElement extensionElement, RoundEnvironment roundEnvironment) {
        Class extensionClass = AnnotationProcessorUtils.classFor(extensionElement, this.processingEnv);
        AnnotationsBasedDescriber describer = new AnnotationsBasedDescriber(extensionClass);
        DefaultDescribingContext context = new DefaultDescribingContext(describer.describe().getRootDeclaration());
        context.getCustomParameters().put(EXTENSION_ELEMENT, extensionElement);
        context.getCustomParameters().put(PROCESSING_ENVIRONMENT, this.processingEnv);
        context.getCustomParameters().put(ROUND_ENVIRONMENT, roundEnvironment);
        return this.extensionFactory.createFrom((Descriptor)context.getDeclarationDescriptor(), (DescribingContext)context);
    }

    private List<TypeElement> findExtensions(RoundEnvironment env) {
        return ImmutableList.copyOf(AnnotationProcessorUtils.getTypeElementsAnnotatedWith(Extension.class, env));
    }

    private void log(String message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, message);
    }
}

