/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api.resolver;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.utils.MetadataTypeUtils;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.TextTypeAnnotation;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.introspection.property.ImportedTypesModelProperty;
import org.mule.runtime.extension.api.introspection.property.LayoutModelProperty;
import org.mule.runtime.extension.api.introspection.property.SubTypesModelProperty;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslResolvingContext;

class DslSyntaxUtils {
    DslSyntaxUtils() {
    }

    static boolean isValidBean(ObjectType objectType) {
        return DslSyntaxUtils.isInstantiable((MetadataType)objectType) && !objectType.getFields().isEmpty();
    }

    static boolean isFlattened(ObjectFieldType field, MetadataType fieldValue) {
        return fieldValue instanceof ObjectType && field.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }

    static String getTypeKey(MetadataType type, String namespace, String namespaceUri) {
        return MetadataTypeUtils.getTypeId((MetadataType)type).orElse(type.getAnnotation(ClassInformationAnnotation.class).map(ClassInformationAnnotation::getName).orElse("")) + namespace + namespaceUri;
    }

    static boolean isText(ParameterModel parameter) {
        return parameter.getModelProperty(LayoutModelProperty.class).map(LayoutModelProperty::isText).orElse(false);
    }

    static boolean isText(MetadataType type) {
        return type.getAnnotation(TextTypeAnnotation.class).isPresent();
    }

    static boolean isInstantiable(MetadataType metadataType) {
        Optional classInformation = metadataType.getAnnotation(ClassInformationAnnotation.class);
        return classInformation.map(ClassInformationAnnotation::isInstantiable).orElse(false);
    }

    static boolean isExtensible(MetadataType metadataType) {
        return metadataType.getAnnotation(ExtensibleTypeAnnotation.class).isPresent();
    }

    static Map<MetadataType, XmlModelProperty> loadImportedTypes(ExtensionModel extension, DslResolvingContext context) {
        HashMap<MetadataType, XmlModelProperty> xmlByType = new HashMap<MetadataType, XmlModelProperty>();
        extension.getModelProperty(ImportedTypesModelProperty.class).map(ImportedTypesModelProperty::getImportedTypes).ifPresent(imports -> imports.forEach((type, ownerExtension) -> {
            ExtensionModel extensionModel = context.getExtension((String)ownerExtension).orElseThrow(() -> new IllegalArgumentException(String.format("The Extension [%s] is not present in the current context", ownerExtension)));
            XmlModelProperty xml = (XmlModelProperty)extensionModel.getModelProperty(XmlModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The Extension [%s] doesn't have the required model property [%s]", ownerExtension, "XML")));
            xmlByType.put((MetadataType)type, xml);
        }));
        return xmlByType;
    }

    static SubTypesMappingContainer loadSubTypes(ExtensionModel extension) {
        return new SubTypesMappingContainer(extension.getModelProperty(SubTypesModelProperty.class).map(SubTypesModelProperty::getSubTypesMapping).orElse((Map)ImmutableMap.of()));
    }

    static XmlModelProperty loadXmlProperties(ExtensionModel extension) {
        return (XmlModelProperty)extension.getModelProperty(XmlModelProperty.class).orElseThrow(() -> new IllegalArgumentException(String.format("The extension [%s] does not have the [%s], required for its Xml Dsl Resolution", extension.getName(), XmlModelProperty.class.getSimpleName())));
    }
}

