/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api.resolver;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javax.xml.namespace.QName;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.DictionaryType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.extension.api.introspection.ExtensionModel;
import org.mule.runtime.extension.api.introspection.Named;
import org.mule.runtime.extension.api.introspection.declaration.type.annotation.XmlHintsAnnotation;
import org.mule.runtime.extension.api.introspection.parameter.ExpressionSupport;
import org.mule.runtime.extension.api.introspection.parameter.ParameterModel;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.SubTypesMappingContainer;
import org.mule.runtime.extension.xml.dsl.api.DslElementSyntax;
import org.mule.runtime.extension.xml.dsl.api.XmlModelUtils;
import org.mule.runtime.extension.xml.dsl.api.property.XmlHintsModelProperty;
import org.mule.runtime.extension.xml.dsl.api.property.XmlModelProperty;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslResolvingContext;
import org.mule.runtime.extension.xml.dsl.api.resolver.DslSyntaxUtils;
import org.mule.runtime.extension.xml.dsl.internal.DslElementSyntaxBuilder;

public class DslSyntaxResolver {
    private static final String VALUE_ATTRIBUTE = "value";
    private static final String KEY_ATTRIBUTE = "key";
    public static final String EMPTY = "";
    private final SubTypesMappingContainer subTypesMap;
    private final XmlModelProperty extensionXml;
    private final Map<String, DslElementSyntaxBuilder> resolvedTypes = new HashMap<String, DslElementSyntaxBuilder>();
    private final DslResolvingContext context;
    private Map<MetadataType, XmlModelProperty> importedTypes;

    public DslSyntaxResolver(ExtensionModel model, DslResolvingContext context) {
        this.context = context;
        this.extensionXml = DslSyntaxUtils.loadXmlProperties(model);
        this.subTypesMap = DslSyntaxUtils.loadSubTypes(model);
        this.importedTypes = DslSyntaxUtils.loadImportedTypes(model, context);
    }

    public DslElementSyntax resolve(Named component) {
        return DslElementSyntaxBuilder.create().withElementName(NameUtils.hyphenize((String)component.getName())).withAbstractElementName(EMPTY).withNamespace(this.extensionXml.getNamespace(), this.extensionXml.getNamespaceUri()).requiresConfig(ExtensionModelUtils.requiresConfig((Named)component)).build();
    }

    public DslElementSyntax resolve(final ParameterModel parameter) {
        final ExpressionSupport expressionSupport = parameter.getExpressionSupport();
        final DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        final String namespace = this.getNamespace(parameter.getType());
        final String namespaceUri = this.getNamespaceUri(parameter.getType());
        final Optional<XmlHintsModelProperty> xmlHints = XmlModelUtils.getHintsModelProperty(parameter);
        parameter.getType().accept(new MetadataTypeVisitor(){

            public void visitUnion(UnionType unionType) {
                unionType.getTypes().forEach(type -> type.accept((MetadataTypeVisitor)this));
            }

            protected void defaultVisit(MetadataType metadataType) {
                builder.withAttributeName(parameter.getName()).withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize((String)parameter.getName()));
            }

            public void visitString(StringType stringType) {
                this.defaultVisit((MetadataType)stringType);
                builder.supportsChildDeclaration(DslSyntaxUtils.isText(parameter));
            }

            public void visitArrayType(ArrayType arrayType) {
                this.defaultVisit((MetadataType)arrayType);
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxResolver.this.supportsInlineDeclaration(genericType, expressionSupport, xmlHints);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(builder, parameter.getName(), namespace, namespaceUri, false));
                }
            }

            public void visitObject(ObjectType objectType) {
                builder.withAttributeName(parameter.getName()).withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize((String)parameter.getName())).withAbstractElementName(DslSyntaxResolver.EMPTY).supportsTopLevelDeclaration(DslSyntaxResolver.this.supportTopLevelElement((MetadataType)objectType, xmlHints));
                boolean shouldGenerateChild = DslSyntaxResolver.this.supportsInlineDeclaration((MetadataType)objectType, expressionSupport, xmlHints);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType);
                if (shouldGenerateChild || requiresWrapper) {
                    builder.supportsChildDeclaration(true);
                    if (requiresWrapper) {
                        builder.asWrappedElement(true).withNamespace(namespace, namespaceUri);
                    } else {
                        builder.withNamespace(DslSyntaxResolver.this.extensionXml.getNamespace(), DslSyntaxResolver.this.extensionXml.getNamespaceUri());
                    }
                    DslSyntaxResolver.this.declareFieldsAsChilds(builder, objectType.getFields(), namespace, namespaceUri);
                    DslSyntaxResolver.this.subTypesMap.getSuperTypes((MetadataType)objectType).stream().map(metadataType -> DslSyntaxResolver.this.resolve((MetadataType)metadataType)).map(element -> DslSyntaxResolver.this.toQName(element)).forEach(builder::ofSubstitutionGroup);
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                builder.withAttributeName(parameter.getName()).withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)parameter.getName()))).supportsChildDeclaration(DslSyntaxResolver.this.supportsInlineDeclaration(dictionaryType.getKeyType(), expressionSupport));
                builder.withGeneric(dictionaryType.getKeyType(), DslElementSyntaxBuilder.create().withAttributeName(DslSyntaxResolver.KEY_ATTRIBUTE).build());
                dictionaryType.getValueType().accept(DslSyntaxResolver.this.getDictionaryValueTypeVisitor(builder, parameter.getName(), namespace, namespaceUri, xmlHints));
            }
        });
        return builder.build();
    }

    public DslElementSyntax resolve(MetadataType type) {
        String namespaceUri;
        if (type == null) {
            throw new IllegalArgumentException("Expected a type to resolve its DslSyntax, but type was null");
        }
        final DslElementSyntaxBuilder builder = DslElementSyntaxBuilder.create();
        final String namespace = this.getNamespace(type);
        String key = DslSyntaxUtils.getTypeKey(type, namespace, namespaceUri = this.getNamespaceUri(type));
        if (this.resolvedTypes.containsKey(key)) {
            return this.resolvedTypes.get(key).build();
        }
        this.resolvedTypes.put(key, builder);
        type.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType);
                boolean supportsChildDeclaration = DslSyntaxResolver.this.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.NOT_SUPPORTED);
                builder.withNamespace(namespace, namespaceUri).withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).withAbstractElementName(NameUtils.getAbstractTopLevelTypeName((MetadataType)objectType)).supportsTopLevelDeclaration(DslSyntaxResolver.this.supportTopLevelElement((MetadataType)objectType, Optional.empty())).supportsChildDeclaration(supportsChildDeclaration).asWrappedElement(requiresWrapper);
                if (supportsChildDeclaration) {
                    DslSyntaxResolver.this.declareFieldsAsChilds(builder, objectType.getFields(), namespace, namespaceUri);
                }
                DslSyntaxResolver.this.subTypesMap.getSuperTypes((MetadataType)objectType).stream().map(metadataType -> DslSyntaxResolver.this.resolve((MetadataType)metadataType)).map(element -> DslSyntaxResolver.this.toQName(element)).forEach(builder::ofSubstitutionGroup);
            }
        });
        return builder.build();
    }

    private MetadataTypeVisitor getArrayItemTypeVisitor(final DslElementSyntaxBuilder listBuilder, final String parameterName, final String namespace, final String namespaceUri, final boolean asItem) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                if (DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, DslElementSyntaxBuilder.create().withNamespace(DslSyntaxResolver.this.getNamespace((MetadataType)objectType), DslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType)).withElementName(NameUtils.getTopLevelTypeName((MetadataType)objectType)).supportsChildDeclaration(DslSyntaxResolver.this.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.NOT_SUPPORTED)).asWrappedElement(true).supportsTopLevelDeclaration(DslSyntaxResolver.this.supportTopLevelElement((MetadataType)objectType, Optional.empty())).build());
                } else if (DslSyntaxUtils.isValidBean(objectType)) {
                    listBuilder.withGeneric((MetadataType)objectType, DslSyntaxResolver.this.resolve((MetadataType)objectType));
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder genericBuilder = DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(DslSyntaxResolver.this.resolveItemName(parameterName, asItem));
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxResolver.this.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    genericBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(genericBuilder, parameterName, namespace, namespaceUri, true));
                }
                listBuilder.withGeneric((MetadataType)arrayType, genericBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                listBuilder.withGeneric(metadataType, DslElementSyntaxBuilder.create().withNamespace(namespace, namespaceUri).withElementName(DslSyntaxResolver.this.resolveItemName(parameterName, asItem)).build());
            }
        };
    }

    private MetadataTypeVisitor getDictionaryValueTypeVisitor(final DslElementSyntaxBuilder mapBuilder, final String parameterName, final String namespace, final String namespaceUri, final Optional<XmlHintsModelProperty> xmlHints) {
        return new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                boolean supportsInlineDeclaration = DslSyntaxResolver.this.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED, xmlHints);
                boolean requiresWrapperElement = DslSyntaxResolver.this.typeRequiresWrapperElement((MetadataType)objectType);
                if (supportsInlineDeclaration || requiresWrapperElement) {
                    DslElementSyntaxBuilder builder = this.createBaseValueDefinition();
                    DslSyntaxResolver.this.addBeanDeclarationSupport(objectType, objectType.getFields(), builder, namespace, namespaceUri);
                    builder.supportsChildDeclaration(true);
                    mapBuilder.withGeneric((MetadataType)objectType, builder.build());
                } else {
                    this.defaultVisit((MetadataType)objectType);
                }
            }

            public void visitArrayType(ArrayType arrayType) {
                DslElementSyntaxBuilder listBuilder = this.createBaseValueDefinition();
                MetadataType genericType = arrayType.getType();
                boolean supportsInline = DslSyntaxResolver.this.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED, xmlHints);
                boolean requiresWrapper = DslSyntaxResolver.this.typeRequiresWrapperElement(genericType);
                if (supportsInline || requiresWrapper) {
                    listBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(listBuilder, parameterName, namespace, namespaceUri, true));
                }
                mapBuilder.withGeneric((MetadataType)arrayType, listBuilder.build());
            }

            protected void defaultVisit(MetadataType metadataType) {
                mapBuilder.withGeneric(metadataType, this.createBaseValueDefinition().build());
            }

            private DslElementSyntaxBuilder createBaseValueDefinition() {
                return DslElementSyntaxBuilder.create().withAttributeName(DslSyntaxResolver.VALUE_ATTRIBUTE).withNamespace(namespace, namespaceUri).withElementName(NameUtils.hyphenize((String)NameUtils.singularize((String)parameterName)));
            }
        };
    }

    private void addBeanDeclarationSupport(ObjectType objectType, Collection<ObjectFieldType> childFields, DslElementSyntaxBuilder builder, String namespace, String namespaceUri) {
        boolean supportsChildDeclaration = this.supportsInlineDeclaration((MetadataType)objectType, ExpressionSupport.SUPPORTED);
        boolean supportsTopDeclaration = this.supportTopLevelElement((MetadataType)objectType);
        builder.supportsChildDeclaration(supportsChildDeclaration).supportsTopLevelDeclaration(supportsTopDeclaration);
        if (supportsChildDeclaration || supportsTopDeclaration) {
            this.declareFieldsAsChilds(builder, childFields, namespace, namespaceUri);
        }
    }

    private MetadataTypeVisitor getObjectFieldVisitor(final DslElementSyntaxBuilder objectFieldBuilder, final ObjectFieldType field, final String fieldName, final String ownerNamespace, final String ownerNamespaceUri) {
        return new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                objectFieldBuilder.withAttributeName(fieldName);
            }

            public void visitString(StringType stringType) {
                if (DslSyntaxUtils.isText((MetadataType)field)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    objectFieldBuilder.withElementName(NameUtils.hyphenize((String)fieldName));
                } else {
                    this.defaultVisit((MetadataType)stringType);
                }
            }

            public void visitObject(ObjectType objectType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)fieldName)).withNamespace(DslSyntaxResolver.this.getNamespace((MetadataType)objectType, ownerNamespace), DslSyntaxResolver.this.getNamespaceUri((MetadataType)objectType, ownerNamespaceUri));
                List fields = objectType.getFields().stream().filter(f -> !f.getValue().equals(objectType)).collect(Collectors.toList());
                DslSyntaxResolver.this.addBeanDeclarationSupport(objectType, fields, objectFieldBuilder, ownerNamespace, ownerNamespaceUri);
            }

            public void visitArrayType(ArrayType arrayType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)fieldName)).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType genericType = arrayType.getType();
                if (DslSyntaxResolver.this.supportsInlineDeclaration(genericType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    genericType.accept(DslSyntaxResolver.this.getArrayItemTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, false));
                }
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                objectFieldBuilder.withAttributeName(fieldName).withElementName(NameUtils.hyphenize((String)NameUtils.pluralize((String)fieldName))).withNamespace(ownerNamespace, ownerNamespaceUri);
                MetadataType keyType = dictionaryType.getKeyType();
                if (DslSyntaxResolver.this.supportsInlineDeclaration(keyType, ExpressionSupport.SUPPORTED)) {
                    objectFieldBuilder.supportsChildDeclaration(true);
                    objectFieldBuilder.withGeneric(dictionaryType.getKeyType(), DslElementSyntaxBuilder.create().withAttributeName(DslSyntaxResolver.KEY_ATTRIBUTE).build());
                    dictionaryType.getValueType().accept(DslSyntaxResolver.this.getDictionaryValueTypeVisitor(objectFieldBuilder, fieldName, ownerNamespace, ownerNamespaceUri, Optional.empty()));
                }
            }
        };
    }

    private void declareFieldsAsChilds(DslElementSyntaxBuilder objectBuilder, Collection<ObjectFieldType> fields, String namespace, String namespaceUri) {
        fields.forEach(field -> {
            DslElementSyntaxBuilder fieldBuilder = DslElementSyntaxBuilder.create();
            String childName = field.getKey().getName().getLocalPart();
            MetadataType fieldValue = field.getValue();
            if (DslSyntaxUtils.isFlattened(field, fieldValue)) {
                this.declareFieldsAsChilds(objectBuilder, ((ObjectType)fieldValue).getFields(), namespace, namespaceUri);
            } else {
                fieldValue.accept(this.getObjectFieldVisitor(fieldBuilder, (ObjectFieldType)field, childName, namespace, namespaceUri));
                objectBuilder.withChild(childName, fieldBuilder.build());
            }
        });
    }

    private boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport) {
        return this.supportsInlineDeclaration(metadataType, expressionSupport, Optional.empty());
    }

    private boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport, final Optional<XmlHintsModelProperty> xmlHints) {
        final AtomicBoolean supportsChildDeclaration = new AtomicBoolean(false);
        if (ExpressionSupport.REQUIRED == expressionSupport) {
            return false;
        }
        metadataType.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                supportsChildDeclaration.set(true);
            }

            public void visitAnyType(AnyType anyType) {
                supportsChildDeclaration.set(false);
            }

            public void visitArrayType(ArrayType arrayType) {
                arrayType.getType().accept((MetadataTypeVisitor)this);
            }

            public void visitObject(ObjectType objectType) {
                if (xmlHints.isPresent() && !((XmlHintsModelProperty)xmlHints.get()).allowsInlineDefinition()) {
                    supportsChildDeclaration.set(false);
                } else {
                    supportsChildDeclaration.set(DslSyntaxUtils.isValidBean(objectType));
                }
            }

            public void visitUnion(UnionType unionType) {
                supportsChildDeclaration.set(false);
            }

            public void visitDictionary(DictionaryType dictionaryType) {
                supportsChildDeclaration.set(true);
            }
        });
        return supportsChildDeclaration.get();
    }

    private boolean supportTopLevelElement(MetadataType metadataType) {
        return this.supportTopLevelElement(metadataType, metadataType.getAnnotation(XmlHintsAnnotation.class).map(XmlHintsAnnotation::allowsReferences).orElse(true));
    }

    private boolean supportTopLevelElement(MetadataType metadataType, Optional<XmlHintsModelProperty> ownerXmlHints) {
        return this.supportTopLevelElement(metadataType, ownerXmlHints.map(XmlHintsModelProperty::allowsReferences).orElse(true));
    }

    private boolean supportTopLevelElement(MetadataType metadataType, boolean allowsReferences) {
        if (!allowsReferences) {
            return false;
        }
        final AtomicBoolean supporstGlobalDeclaration = new AtomicBoolean(false);
        metadataType.accept(new MetadataTypeVisitor(){

            public void visitObject(ObjectType objectType) {
                supporstGlobalDeclaration.set(XmlModelUtils.supportsTopLevelDeclaration((MetadataType)objectType) && DslSyntaxUtils.isValidBean(objectType));
            }
        });
        return supporstGlobalDeclaration.get();
    }

    private boolean typeRequiresWrapperElement(MetadataType metadataType) {
        boolean isPojo = metadataType instanceof ObjectType;
        boolean hasSubtypes = this.subTypesMap.containsBaseType(metadataType);
        return isPojo && (DslSyntaxUtils.isExtensible(metadataType) || hasSubtypes);
    }

    private String getNamespace(MetadataType type) {
        return this.getNamespace(type, this.extensionXml.getNamespace());
    }

    private String getNamespace(MetadataType type, String defaultNamespace) {
        XmlModelProperty originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespace() : defaultNamespace;
    }

    private String getNamespaceUri(MetadataType type) {
        return this.getNamespaceUri(type, this.extensionXml.getNamespaceUri());
    }

    private String getNamespaceUri(MetadataType type, String defaultUri) {
        XmlModelProperty originXml = this.importedTypes.get(type);
        return originXml != null ? originXml.getNamespaceUri() : defaultUri;
    }

    private QName toQName(DslElementSyntax elementSyntax) {
        return new QName(elementSyntax.getNamespaceUri(), elementSyntax.getAbstractElementName(), elementSyntax.getNamespace());
    }

    private String resolveItemName(String parameterName, boolean forceItemize) {
        String singularizedName = NameUtils.singularize((String)parameterName);
        return forceItemize || parameterName.equals(singularizedName) ? NameUtils.itemize((String)singularizedName) : NameUtils.hyphenize((String)singularizedName);
    }
}

