/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.xml.dsl.api;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.model.MetadataType;

public class DslElementSyntax {
    private final String attributeName;
    private final String elementName;
    private final String abstractElementName;
    private final String elementNameSpace;
    private final String nameSpaceUri;
    private final boolean isWrapped;
    private final boolean supportsChildDeclaration;
    private final boolean supportsTopLevelDeclaration;
    private final boolean requiresConfig;
    private final Map<MetadataType, DslElementSyntax> genericsDsl;
    private final Map<String, DslElementSyntax> childsByName;
    private final List<QName> substitutionGroups;

    public DslElementSyntax(String attributeName, String elementName, String abstractElementName, String elementNameSpace, String nameSpaceUri, boolean isWrapped, boolean supportsChildDeclaration, boolean supportsTopLevelDeclaration, boolean requiresConfig, Map<MetadataType, DslElementSyntax> genericsDsl, Map<String, DslElementSyntax> childsByName, List<QName> substitutionGroups) {
        this.attributeName = attributeName;
        this.elementName = elementName;
        this.abstractElementName = abstractElementName;
        this.elementNameSpace = elementNameSpace;
        this.nameSpaceUri = nameSpaceUri;
        this.isWrapped = isWrapped;
        this.supportsChildDeclaration = supportsChildDeclaration;
        this.supportsTopLevelDeclaration = supportsTopLevelDeclaration;
        this.requiresConfig = requiresConfig;
        this.genericsDsl = genericsDsl;
        this.childsByName = childsByName;
        this.substitutionGroups = substitutionGroups;
    }

    public String getElementName() {
        return this.elementName;
    }

    public String getNamespace() {
        return this.elementNameSpace;
    }

    public String getNamespaceUri() {
        return this.nameSpaceUri;
    }

    public boolean isWrapped() {
        return this.isWrapped;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean supportsChildDeclaration() {
        return this.supportsChildDeclaration;
    }

    public boolean supportsTopLevelDeclaration() {
        return this.supportsTopLevelDeclaration;
    }

    public String getAbstractElementName() {
        return this.abstractElementName;
    }

    public List<QName> getSubstitutionGroups() {
        ImmutableList.Builder builder = ImmutableList.builder();
        if (!StringUtils.isBlank((CharSequence)this.getAbstractElementName())) {
            builder.add((Object)new QName(this.getNamespaceUri(), this.getAbstractElementName(), this.getNamespace()));
        }
        return builder.addAll(this.substitutionGroups).build();
    }

    public Optional<DslElementSyntax> getGeneric(MetadataType type) {
        return Optional.ofNullable(this.genericsDsl.get(type));
    }

    public Optional<DslElementSyntax> getChild(String name) {
        return Optional.ofNullable(this.childsByName.get(name));
    }

    public boolean requiresConfig() {
        return this.requiresConfig;
    }
}

