/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.testutil.common;

import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.ws.BindingProvider;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.testutil.common.AbstractTestServerBase;
import org.apache.cxf.testutil.common.ServerLauncher;
import org.apache.cxf.testutil.common.TestUtil;
import org.junit.AfterClass;
import org.junit.Assert;

public abstract class AbstractClientServerTestBase
extends Assert {
    private static List<ServerLauncher> launchers = new ArrayList<ServerLauncher>();

    @AfterClass
    public static void stopAllServers() throws Exception {
        boolean passed = true;
        for (ServerLauncher sl : launchers) {
            try {
                sl.signalStop();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        for (ServerLauncher sl : launchers) {
            try {
                passed = passed && sl.stopServer();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        launchers.clear();
        System.gc();
        AbstractClientServerTestBase.assertTrue((String)"server failed", (boolean)passed);
    }

    public static boolean launchServer(AbstractTestServerBase base) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(base);
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + (Object)((Object)base)));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(clz.getName());
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + clz));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz, boolean inProcess) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(clz.getName(), inProcess);
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + clz));
        }
        return ok;
    }

    public static boolean launchServer(Class<?> clz, Map<String, String> props, String[] args) {
        return AbstractClientServerTestBase.launchServer(clz, props, args, false);
    }

    public static boolean launchServer(Class<?> clz, Map<String, String> props, String[] args, boolean inProcess) {
        boolean ok = false;
        try {
            ServerLauncher sl = new ServerLauncher(clz.getName(), props, args, inProcess);
            ok = sl.launchServer();
            AbstractClientServerTestBase.assertTrue((String)"server failed to launch", (boolean)ok);
            launchers.add(0, sl);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            AbstractClientServerTestBase.fail((String)("failed to launch server " + clz));
        }
        return ok;
    }

    protected void setAddress(Object o, String address) {
        if (o instanceof BindingProvider) {
            ((BindingProvider)o).getRequestContext().put("javax.xml.ws.service.endpoint.address", address);
        }
        Client c = null;
        if (o instanceof Client) {
            c = (Client)o;
        }
        if (c == null) {
            try {
                InvocationHandler i = Proxy.getInvocationHandler(o);
                c = (Client)i.getClass().getMethod("getClient", new Class[0]).invoke((Object)i, new Object[0]);
            }
            catch (Throwable i) {
                // empty catch block
            }
        }
        if (c == null) {
            try {
                Method m = o.getClass().getDeclaredMethod("getClient", new Class[0]);
                ReflectionUtil.setAccessible((AccessibleObject)m);
                c = (Client)m.invoke(o, new Object[0]);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (c != null) {
            c.getEndpoint().getEndpointInfo().setAddress(address);
        }
    }

    protected void updateAddressPort(Object o, String port) throws NumberFormatException, MalformedURLException {
        this.updateAddressPort(o, Integer.parseInt(port));
    }

    protected void updateAddressPort(Object o, int port) throws MalformedURLException {
        String address = null;
        if (o instanceof BindingProvider) {
            address = ((BindingProvider)o).getRequestContext().get("javax.xml.ws.service.endpoint.address").toString();
        } else if (o instanceof Client) {
            Client c = (Client)o;
            address = c.getEndpoint().getEndpointInfo().getAddress();
        }
        if (address != null) {
            URL url = new URL(address);
            url = new URL(url.getProtocol(), url.getHost(), port, url.getFile());
            this.setAddress(o, url.toString());
        }
    }

    protected static String allocatePort(String s) {
        return TestUtil.getPortNumber(s);
    }

    protected static String allocatePort(Class<?> cls) {
        return TestUtil.getPortNumber(cls);
    }

    protected static String allocatePort(Class<?> cls, int count) {
        return TestUtil.getPortNumber(cls, count);
    }
}

