/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.soap.interceptor;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.cxf.binding.soap.Soap11;
import org.apache.cxf.binding.soap.Soap12;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.binding.soap.SoapVersion;
import org.apache.cxf.binding.soap.interceptor.AbstractSoapInterceptor;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.service.model.BindingOperationInfo;

public class SoapPreProtocolOutInterceptor
extends AbstractSoapInterceptor {
    public SoapPreProtocolOutInterceptor() {
        super("post-logical");
    }

    public void handleMessage(SoapMessage message) throws Fault {
        this.ensureVersion(message);
        this.ensureMimeHeaders(message);
        if (this.isRequestor((Message)message)) {
            this.setSoapAction(message);
        }
    }

    private void ensureVersion(SoapMessage message) {
        SoapVersion soapVersion = message.getVersion();
        if (soapVersion == null && message.getExchange().getInMessage() instanceof SoapMessage) {
            soapVersion = ((SoapMessage)message.getExchange().getInMessage()).getVersion();
            message.setVersion(soapVersion);
        }
        if (soapVersion == null) {
            soapVersion = Soap11.getInstance();
            message.setVersion(soapVersion);
        }
        message.put("Content-Type", soapVersion.getContentType());
    }

    private void ensureMimeHeaders(SoapMessage message) {
        if (message.get("org.apache.cxf.mime.headers") == null) {
            message.put("org.apache.cxf.mime.headers", new HashMap());
        }
    }

    private void setSoapAction(SoapMessage message) {
        String ct;
        BindingOperationInfo boi = message.getExchange().getBindingOperationInfo();
        if (boi != null && boi.isUnwrapped()) {
            boi = boi.getWrappedOperation();
        }
        String action = this.getSoapAction(message, boi);
        if (message.getVersion() instanceof Soap11) {
            TreeMap<String, List<String>> reqHeaders = CastUtils.cast((Map)((Map)message.get(Message.PROTOCOL_HEADERS)));
            if (reqHeaders == null) {
                reqHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            }
            if (reqHeaders.size() == 0) {
                message.put(Message.PROTOCOL_HEADERS, reqHeaders);
            }
            reqHeaders.put("SOAPAction", Collections.singletonList(action));
        } else if (message.getVersion() instanceof Soap12 && !"\"\"".equals(action) && (ct = (String)message.get("Content-Type")).indexOf("action=\"") == -1) {
            ct = ct + "; action=" + action;
            message.put("Content-Type", ct);
        }
    }

    private String getSoapAction(SoapMessage message, BindingOperationInfo boi) {
        String action = (String)message.get("SOAPAction");
        if (action == null) {
            if (boi == null) {
                action = "\"\"";
            } else {
                SoapOperationInfo soi = (SoapOperationInfo)boi.getExtensor(SoapOperationInfo.class);
                String string = soi == null ? "\"\"" : (action = soi.getAction() == null ? "\"\"" : soi.getAction());
            }
        }
        if (!action.startsWith("\"")) {
            action = "\"" + action + "\"";
        }
        return action;
    }
}

