/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.reader;

import com.mulesoft.weave.module.reader.CharsetHelper$;
import com.mulesoft.weave.module.reader.SeekableStream;
import com.mulesoft.weave.module.reader.SourceReader;
import com.mulesoft.weave.module.reader.SourceReader$class;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005-a\u0001B\u0001\u0003\u00015\u0011a#\u0016+GqM#(/Z1n'>,(oY3SK\u0006$WM\u001d\u0006\u0003\u0007\u0011\taA]3bI\u0016\u0014(BA\u0003\u0007\u0003\u0019iw\u000eZ;mK*\u0011q\u0001C\u0001\u0006o\u0016\fg/\u001a\u0006\u0003\u0013)\t\u0001\"\\;mKN|g\r\u001e\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"A\u0001\u0007T_V\u00148-\u001a*fC\u0012,'\u000f\u0003\u0005\u001a\u0001\t\u0005\t\u0015!\u0003\u001b\u00039\u0019X-Z6bE2,7\u000b\u001e:fC6\u0004\"!F\u000e\n\u0005q\u0011!AD*fK.\f'\r\\3TiJ,\u0017-\u001c\u0005\t=\u0001\u0011\t\u0011)A\u0005?\u000591\r[1sg\u0016$\bC\u0001\u0011'\u001b\u0005\t#B\u0001\u0010#\u0015\t\u0019C%A\u0002oS>T\u0011!J\u0001\u0005U\u00064\u0018-\u0003\u0002(C\t91\t[1sg\u0016$\b\"B\u0015\u0001\t\u0003Q\u0013A\u0002\u001fj]&$h\bF\u0002,Y5\u0002\"!\u0006\u0001\t\u000beA\u0003\u0019\u0001\u000e\t\u000byA\u0003\u0019A\u0010\t\u0011=\u0002\u0001R1A\u0005\u0002A\nq\u0001Z3d_\u0012,'/F\u00012!\t\u0001#'\u0003\u00024C\tq1\t[1sg\u0016$H)Z2pI\u0016\u0014\b\u0002C\u001b\u0001\u0011\u0003\u0005\u000b\u0015B\u0019\u0002\u0011\u0011,7m\u001c3fe\u0002Bqa\u000e\u0001C\u0002\u0013%\u0001(\u0001\u0006dQ\u0006\u0014()\u001e4gKJ,\u0012!\u000f\t\u0003umj\u0011AI\u0005\u0003y\t\u0012!b\u00115be\n+hMZ3s\u0011\u0019q\u0004\u0001)A\u0005s\u0005Y1\r[1s\u0005V4g-\u001a:!\u0011\u001d\u0001\u0005\u00011A\u0005\na\nQBY5h\u0007\"\f'OQ;gM\u0016\u0014\bb\u0002\"\u0001\u0001\u0004%IaQ\u0001\u0012E&<7\t[1s\u0005V4g-\u001a:`I\u0015\fHC\u0001#H!\tyQ)\u0003\u0002G!\t!QK\\5u\u0011\u001dA\u0015)!AA\u0002e\n1\u0001\u001f\u00132\u0011\u0019Q\u0005\u0001)Q\u0005s\u0005q!-[4DQ\u0006\u0014()\u001e4gKJ\u0004\u0003b\u0002'\u0001\u0001\u0004%\t!T\u0001\u000b?J,\u0017\r\u001a\"zi\u0016\u001cX#\u0001(\u0011\u0005=y\u0015B\u0001)\u0011\u0005\rIe\u000e\u001e\u0005\b%\u0002\u0001\r\u0011\"\u0001T\u00039y&/Z1e\u0005f$Xm]0%KF$\"\u0001\u0012+\t\u000f!\u000b\u0016\u0011!a\u0001\u001d\"1a\u000b\u0001Q!\n9\u000b1b\u0018:fC\u0012\u0014\u0015\u0010^3tA!)\u0001\f\u0001C!3\u0006I!/Z1e\u0003N\u001c\u0017.\u001b\u000b\u00025B\u0011qbW\u0005\u00039B\u0011Aa\u00115be\")a\f\u0001C\u0001?\u0006I\u0001.\u00198eY\u0016\u0014u*\u0014\u000b\u0002\t\")\u0011\r\u0001C!E\u0006A\u0001o\\:ji&|g\u000eF\u0001d!\tyA-\u0003\u0002f!\t!Aj\u001c8h\u0011\u00159\u0007\u0001\"\u0011c\u0003A\u0001(/\u001a<j_V\u001c\bk\\:ji&|g\u000eC\u0003j\u0001\u0011\u0005\u0013,\u0001\bm_>\\\u0017\t[3bI\u0006\u001b8-[5\t\u000b-\u0004A\u0011\t7\u0002\tM,Wm\u001b\u000b\u0003\t6DQ!\u00196A\u0002\rDQa\u001c\u0001\u0005Be\u000bAA]3bI\")\u0011\u000f\u0001C\u0001e\u0006\t\"/Z1e\u000b:\u001cw\u000eZ3e'R\u0014\u0018N\\4\u0015\u0007MTH\u0010\u0005\u0002uo:\u0011q\"^\u0005\u0003mB\ta\u0001\u0015:fI\u00164\u0017B\u0001=z\u0005\u0019\u0019FO]5oO*\u0011a\u000f\u0005\u0005\u0006wB\u0004\raY\u0001\u0005MJ|W\u000eC\u0003~a\u0002\u00071-\u0001\u0004mK:<G\u000f\u001b\u0005\u0007\u007f\u0002!\t%!\u0001\u0002\u001fI,\u0017\rZ!tG&L7\u000b\u001e:j]\u001e$Ra]A\u0002\u0003\u000bAQa\u001f@A\u0002\rDQ! @A\u0002\rDa!!\u0003\u0001\t\u0003z\u0016!B2m_N,\u0007")
public class UTF8StreamSourceReader
implements SourceReader {
    private final SeekableStream seekableStream;
    private final Charset charset;
    private CharsetDecoder decoder;
    private final CharBuffer charBuffer;
    private CharBuffer bigCharBuffer;
    private int _readBytes;
    private volatile boolean bitmap$0;

    private CharsetDecoder decoder$lzycompute() {
        UTF8StreamSourceReader uTF8StreamSourceReader = this;
        synchronized (uTF8StreamSourceReader) {
            if (!this.bitmap$0) {
                this.decoder = this.charset.newDecoder();
                this.bitmap$0 = true;
            }
            return this.decoder;
        }
    }

    public CharsetDecoder decoder() {
        return this.bitmap$0 ? this.decoder : this.decoder$lzycompute();
    }

    private CharBuffer charBuffer() {
        return this.charBuffer;
    }

    private CharBuffer bigCharBuffer() {
        return this.bigCharBuffer;
    }

    private void bigCharBuffer_$eq(CharBuffer x$1) {
        this.bigCharBuffer = x$1;
    }

    public int _readBytes() {
        return this._readBytes;
    }

    public void _readBytes_$eq(int x$1) {
        this._readBytes = x$1;
    }

    @Override
    public char readAscii() {
        char c;
        int read;
        if (this.seekableStream.position() == 0L) {
            this.handleBOM();
        }
        if ((read = ((InputStream)((Object)this.seekableStream)).read()) != -1) {
            this._readBytes_$eq(1);
            c = (char)(read & 0xFF);
        } else {
            this._readBytes_$eq(0);
            c = '\uffff';
        }
        return c;
    }

    public void handleBOM() {
        Option<byte[]> mayBeBom = CharsetHelper$.MODULE$.getBom(this.charset);
        byte[] bom = (byte[])mayBeBom.get();
        byte[] inputBom = new byte[bom.length];
        ((InputStream)((Object)this.seekableStream)).read(inputBom);
        if (inputBom[0] != bom[0] || inputBom[1] != bom[1] || inputBom[2] != bom[2]) {
            this.seekableStream.seek(0L);
        }
    }

    @Override
    public long position() {
        return this.seekableStream.position();
    }

    @Override
    public long previousPosition() {
        return this.position() - (long)this._readBytes();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public char lookAheadAscii() {
        char c;
        long startPosition = this.position();
        try {
            c = this.readAscii();
            this.seek(startPosition);
        }
        catch (Throwable throwable) {
            void var1_1;
            this.seek((long)var1_1);
            throw throwable;
        }
        return c;
    }

    @Override
    public void seek(long position) {
        this.seekableStream.seek(position);
    }

    @Override
    public char read() {
        char c;
        byte _read = (byte)((InputStream)((Object)this.seekableStream)).read();
        if (_read == -1) {
            this._readBytes_$eq(0);
            c = '\uffff';
        } else if (_read >= 0) {
            this._readBytes_$eq(1);
            c = (char)_read;
        } else if ((_read & 0xE0) == 192) {
            this._readBytes_$eq(2);
            c = this.decode$1(_read, 1);
        } else if ((_read & 0xF0) == 224) {
            this._readBytes_$eq(3);
            c = this.decode$1(_read, 2);
        } else if ((_read & 0xF8) == 240) {
            this._readBytes_$eq(4);
            c = this.decode$1(_read, 3);
        } else {
            c = (char)65533;
        }
        return c;
    }

    @Override
    public String readEncodedString(long from, long length) {
        byte[] bytes = new byte[(int)length];
        this.seek(from);
        ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        if ((long)this.bigCharBuffer().capacity() < length) {
            this.bigCharBuffer_$eq(CharBuffer.allocate((int)length));
        }
        this.bigCharBuffer().clear();
        CoderResult cr = this.decoder().decode(ByteBuffer.wrap(bytes), this.bigCharBuffer(), false);
        int decodedLength = this.bigCharBuffer().position();
        return new String(this.bigCharBuffer().array(), 0, decodedLength);
    }

    @Override
    public String readAsciiString(long from, long length) {
        byte[] bytes = new byte[(int)length];
        this.seek(from);
        ((InputStream)((Object)this.seekableStream)).read(bytes, 0, (int)length);
        return new String(bytes, StandardCharsets.US_ASCII);
    }

    @Override
    public void close() {
        ((InputStream)((Object)this.seekableStream)).close();
    }

    private final char decode$1(byte by, int remainingBytes) {
        this.charBuffer().clear();
        byte[] bytes = new byte[remainingBytes + 1];
        bytes[0] = by;
        ((InputStream)((Object)this.seekableStream)).read(bytes, 1, remainingBytes);
        this.decoder().decode(ByteBuffer.wrap(bytes), this.charBuffer(), false);
        this.charBuffer().flip();
        return this.charBuffer().get();
    }

    public UTF8StreamSourceReader(SeekableStream seekableStream, Charset charset2) {
        this.seekableStream = seekableStream;
        this.charset = charset2;
        SourceReader$class.$init$(this);
        this.charBuffer = CharBuffer.allocate(1);
        this.bigCharBuffer = CharBuffer.allocate(8192);
        this._readBytes = 0;
    }
}

