/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.reader;

import com.mulesoft.weave.module.reader.CharsetEncoder;
import com.mulesoft.weave.module.reader.CharsetEncoder$;
import com.mulesoft.weave.module.reader.StreamDecoder$;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005es!B\u0001\u0003\u0011\u0003i\u0011!D*ue\u0016\fW\u000eR3d_\u0012,'O\u0003\u0002\u0004\t\u00051!/Z1eKJT!!\u0002\u0004\u0002\r5|G-\u001e7f\u0015\t9\u0001\"A\u0003xK\u00064XM\u0003\u0002\n\u0015\u0005AQ.\u001e7fg>4GOC\u0001\f\u0003\r\u0019w.\\\u0002\u0001!\tqq\"D\u0001\u0003\r\u0015\u0001\"\u0001#\u0001\u0012\u00055\u0019FO]3b[\u0012+7m\u001c3feN\u0011qB\u0005\t\u0003'Yi\u0011\u0001\u0006\u0006\u0002+\u0005)1oY1mC&\u0011q\u0003\u0006\u0002\u0007\u0003:L(+\u001a4\t\u000beyA\u0011\u0001\u000e\u0002\rqJg.\u001b;?)\u0005i\u0001b\u0002\u000f\u0010\u0005\u0004%I!H\u0001\u0019\t\u00163\u0015)\u0016'U?\nKF+R0C+\u001a3UIU0T\u0013j+U#\u0001\u0010\u0011\u0005My\u0012B\u0001\u0011\u0015\u0005\rIe\u000e\u001e\u0005\u0007E=\u0001\u000b\u0011\u0002\u0010\u00023\u0011+e)Q+M)~\u0013\u0015\fV#`\u0005V3e)\u0012*`'&SV\t\t\u0005\u0006I=!\t!J\u0001\u0015M>\u0014\u0018J\u001c9viN#(/Z1n%\u0016\fG-\u001a:\u0015\u000b\u0019\n)&a\u0016\u0011\u000599c\u0001\u0002\t\u0003\u0001!\u001a\"a\n\n\t\u0011):#Q1A\u0005\u0002-\n!!\u001b8\u0016\u00031\u0002\"!\f\u001a\u000e\u00039R!a\f\u0019\u0002\u0005%|'\"A\u0019\u0002\t)\fg/Y\u0005\u0003g9\u00121\"\u00138qkR\u001cFO]3b[\"AQg\nB\u0001B\u0003%A&A\u0002j]\u0002B\u0001bN\u0014\u0003\u0006\u0004%\t\u0001O\u0001\u0003GN,\u0012!\u000f\t\u0003u}j\u0011a\u000f\u0006\u0003yu\nqa\u00195beN,GO\u0003\u0002?a\u0005\u0019a.[8\n\u0005\u0001[$aB\"iCJ\u001cX\r\u001e\u0005\t\u0005\u001e\u0012\t\u0011)A\u0005s\u0005\u00191m\u001d\u0011\t\u000be9C\u0011\u0001#\u0015\u0007\u0019*e\tC\u0003+\u0007\u0002\u0007A\u0006C\u00038\u0007\u0002\u0007\u0011\bC\u0004IO\t\u0007I\u0011B%\u0002\u000f\u0011,7m\u001c3feV\t!\n\u0005\u0002;\u0017&\u0011Aj\u000f\u0002\u000f\u0007\"\f'o]3u\t\u0016\u001cw\u000eZ3s\u0011\u0019qu\u0005)A\u0005\u0015\u0006AA-Z2pI\u0016\u0014\b\u0005\u0003\u0005QO!\u0015\r\u0011\"\u0003R\u0003\t\u0011'-F\u0001S!\t\u0019F+D\u0001>\u0013\t)VH\u0001\u0006CsR,')\u001e4gKJD\u0001bV\u0014\t\u0002\u0003\u0006KAU\u0001\u0004E\n\u0004\u0003\u0002C-(\u0011\u000b\u0007I\u0011\u0002.\u0002\u000f\u0015t7m\u001c3feV\t1\f\u0005\u0002\u000f9&\u0011QL\u0001\u0002\u000f\u0007\"\f'o]3u\u000b:\u001cw\u000eZ3s\u0011!yv\u0005#A!B\u0013Y\u0016\u0001C3oG>$WM\u001d\u0011\t\u000f\u0005<\u0003\u0019!C\u0005E\u0006\u0001\u0002.\u0019<f\u0019\u00164Go\u001c<fe\u000eC\u0017M]\u000b\u0002GB\u00111\u0003Z\u0005\u0003KR\u0011qAQ8pY\u0016\fg\u000eC\u0004hO\u0001\u0007I\u0011\u00025\u0002)!\fg/\u001a'fMR|g/\u001a:DQ\u0006\u0014x\fJ3r)\tIG\u000e\u0005\u0002\u0014U&\u00111\u000e\u0006\u0002\u0005+:LG\u000fC\u0004nM\u0006\u0005\t\u0019A2\u0002\u0007a$\u0013\u0007\u0003\u0004pO\u0001\u0006KaY\u0001\u0012Q\u00064X\rT3gi>4XM]\"iCJ\u0004\u0003bB9(\u0001\u0004%IA]\u0001\rY\u00164Go\u001c<fe\u000eC\u0017M]\u000b\u0002gB\u00111\u0003^\u0005\u0003kR\u0011Aa\u00115be\"9qo\na\u0001\n\u0013A\u0018\u0001\u00057fMR|g/\u001a:DQ\u0006\u0014x\fJ3r)\tI\u0017\u0010C\u0004nm\u0006\u0005\t\u0019A:\t\rm<\u0003\u0015)\u0003t\u00035aWM\u001a;pm\u0016\u00148\t[1sA!)Qp\nC\u0001}\u0006)\"/Z7bS:Lgn\u001a\"zi\u0016\u001c\u0018J\\\"bG\",G#\u0001\u0010\t\u000f\u0005\u0005q\u0005\"\u0001\u0002\u0004\u0005Y!-\u001f;fg2+gn\u001a;i)\rq\u0012Q\u0001\u0005\u0007\u0003\u000fy\b\u0019A:\u0002\u0003\rDq!a\u0003(\t\u0003\ti!A\u0003dY\u0016\f'\u000fF\u0001j\u0011\u0019\t\tb\nC\u0001}\u00061A-Z2pI\u0016Dc!a\u0004\u0002\u0016\u0005\u0005\u0002#B\n\u0002\u0018\u0005m\u0011bAA\r)\t1A\u000f\u001b:poN\u00042!LA\u000f\u0013\r\tyB\f\u0002\f\u0013>+\u0005pY3qi&|gn\t\u0002\u0002\u001c!9\u0011QE\u0014\u0005\u0002\u0005\u001d\u0012\u0001\u0002:fC\u0012$rAHA\u0015\u0003g\t9\u0004\u0003\u0005\u0002,\u0005\r\u0002\u0019AA\u0017\u0003\u0011\u0019'-\u001e4\u0011\tM\tyc]\u0005\u0004\u0003c!\"!B!se\u0006L\bbBA\u001b\u0003G\u0001\rAH\u0001\u0007_\u001a47/\u001a;\t\u000f\u0005e\u00121\u0005a\u0001=\u00051A.\u001a8hi\"Dc!a\t\u0002\u0016\u0005\u0005\u0002BBA O\u0011%Q$A\u0005sK\u0006$')\u001f;fg\"2\u0011QHA\u000b\u0003CAq!!\u0012(\t\u0013\t9%\u0001\u0005j[Bd'+Z1e)\u001dq\u0012\u0011JA&\u0003\u001fB\u0001\"a\u000b\u0002D\u0001\u0007\u0011Q\u0006\u0005\b\u0003\u001b\n\u0019\u00051\u0001\u001f\u0003\rygM\u001a\u0005\b\u0003#\n\u0019\u00051\u0001\u001f\u0003\r)g\u000e\u001a\u0015\u0007\u0003\u0007\n)\"!\t\t\u000b)\u001a\u0003\u0019\u0001\u0017\t\u000b]\u001a\u0003\u0019A\u001d")
public class StreamDecoder {
    private final InputStream in;
    private final Charset cs;
    private final CharsetDecoder decoder;
    private ByteBuffer bb;
    private CharsetEncoder encoder;
    private boolean haveLeftoverChar;
    private char leftoverChar;
    private volatile byte bitmap$0;

    public static StreamDecoder forInputStreamReader(InputStream inputStream, Charset charset2) {
        return StreamDecoder$.MODULE$.forInputStreamReader(inputStream, charset2);
    }

    /*
     * WARNING - void declaration
     */
    private ByteBuffer bb$lzycompute() {
        StreamDecoder streamDecoder = this;
        synchronized (streamDecoder) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                void var2_2;
                ByteBuffer byteBuffer = ByteBuffer.allocate(StreamDecoder$.MODULE$.com$mulesoft$weave$module$reader$StreamDecoder$$DEFAULT_BYTE_BUFFER_SIZE());
                byteBuffer.flip();
                this.bb = var2_2;
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
            return this.bb;
        }
    }

    private CharsetEncoder encoder$lzycompute() {
        StreamDecoder streamDecoder = this;
        synchronized (streamDecoder) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.encoder = CharsetEncoder$.MODULE$.apply(this.cs());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
            return this.encoder;
        }
    }

    public InputStream in() {
        return this.in;
    }

    public Charset cs() {
        return this.cs;
    }

    private CharsetDecoder decoder() {
        return this.decoder;
    }

    private ByteBuffer bb() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.bb$lzycompute() : this.bb;
    }

    private CharsetEncoder encoder() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.encoder$lzycompute() : this.encoder;
    }

    private boolean haveLeftoverChar() {
        return this.haveLeftoverChar;
    }

    private void haveLeftoverChar_$eq(boolean x$1) {
        this.haveLeftoverChar = x$1;
    }

    private char leftoverChar() {
        return this.leftoverChar;
    }

    private void leftoverChar_$eq(char x$1) {
        this.leftoverChar = x$1;
    }

    /*
     * WARNING - void declaration
     */
    public int remainingBytesInCache() {
        void var1_1;
        int remaining = this.bb().remaining();
        if (this.haveLeftoverChar()) {
            remaining += this.bytesLength(this.leftoverChar());
        }
        return (int)var1_1;
    }

    public int bytesLength(char c) {
        return this.encoder().bytesLength(c);
    }

    public void clear() {
        this.bb().clear();
        this.bb().flip();
        this.haveLeftoverChar_$eq(false);
    }

    public int decode() throws IOException {
        int n;
        if (this.haveLeftoverChar()) {
            this.haveLeftoverChar_$eq(false);
            n = this.leftoverChar();
        } else {
            int n2;
            char[] cb = new char[2];
            int n3 = n2 = this.read(cb, 0, cb.length);
            switch (n3) {
                default: {
                    n = -1;
                    break;
                }
                case 1: {
                    n = cb[0];
                    break;
                }
                case 2: {
                    this.leftoverChar_$eq(cb[1]);
                    this.haveLeftoverChar_$eq(true);
                    n = cb[0];
                }
            }
        }
        return n;
    }

    public int read(char[] cbuf, int offset, int length) throws IOException {
        if (offset < 0 || offset > cbuf.length || length < 0 || offset + length > cbuf.length || offset + length < 0) {
            throw new IndexOutOfBoundsException();
        }
        return length == 0 ? 0 : this.implRead(cbuf, offset, offset + length);
    }

    private int readBytes() throws IOException {
        this.bb().compact();
        try {
            int lim = this.bb().limit();
            int pos = this.bb().position();
            int rem = pos <= lim ? lim - pos : 0;
            int n = this.in().read(this.bb().array(), this.bb().arrayOffset() + pos, rem);
            if (n < 0) {
                return n;
            }
            if (n == 0) {
                throw new IOException("Underlying input stream returned zero bytes");
            }
            this.bb().position(pos + n);
            return this.bb().remaining();
        }
        finally {
            this.bb().flip();
        }
    }

    private int implRead(char[] cbuf, int off, int end) throws IOException {
        CharBuffer cb = CharBuffer.wrap(cbuf, off, end - off);
        if (cb.position() != 0) {
            cb = cb.slice();
        }
        boolean eof = false;
        boolean needMoreBytes = true;
        Object object = this.bb().remaining() == 0 ? BoxesRunTime.boxToInteger((int)this.readBytes()) : BoxedUnit.UNIT;
        while (needMoreBytes) {
            Object object2;
            CoderResult cr = this.decoder().decode(this.bb(), cb, eof);
            if (cr.isUnderflow()) {
                if (eof) {
                    needMoreBytes = false;
                    object2 = BoxedUnit.UNIT;
                    continue;
                }
                if (cb.hasRemaining()) {
                    if (cb.position() > 0) {
                        needMoreBytes = false;
                        object2 = BoxedUnit.UNIT;
                        continue;
                    }
                    int n = this.readBytes();
                    if (n < 0) {
                        eof = true;
                        if (cb.position() == 0 && !this.bb().hasRemaining()) {
                            needMoreBytes = false;
                            object2 = BoxedUnit.UNIT;
                            continue;
                        }
                        object2 = this.decoder().reset();
                        continue;
                    }
                    object2 = BoxedUnit.UNIT;
                    continue;
                }
                needMoreBytes = false;
                object2 = BoxedUnit.UNIT;
                continue;
            }
            if (cr.isOverflow()) {
                needMoreBytes = false;
            } else {
                cr.throwException();
            }
            object2 = BoxedUnit.UNIT;
        }
        Object object3 = eof ? this.decoder().reset() : BoxedUnit.UNIT;
        if (cb.position() == 0 && eof) {
            return -1;
        }
        return cb.position();
    }

    public StreamDecoder(InputStream in, Charset cs) {
        this.in = in;
        this.cs = cs;
        this.decoder = cs.newDecoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
        this.haveLeftoverChar = false;
        this.leftoverChar = '\u0000';
    }
}

