/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.pojo.writer.converter;

import com.mulesoft.weave.model.structure.schema.Schema;
import com.mulesoft.weave.module.pojo.writer.converter.CalendarDataConverter$;
import com.mulesoft.weave.module.pojo.writer.converter.DataConverter;
import com.mulesoft.weave.module.pojo.writer.converter.DataConverter$class;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.threeten.bp.LocalDate;
import org.threeten.bp.LocalDateTime;
import org.threeten.bp.LocalTime;
import org.threeten.bp.OffsetTime;
import org.threeten.bp.ZoneId;
import org.threeten.bp.ZoneOffset;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.ChronoField;
import org.threeten.bp.temporal.TemporalField;
import scala.Function0;
import scala.Option;
import scala.Option$;
import scala.Serializable;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\u00014A!\u0001\u0002\u0001#\t)2)\u00197f]\u0012\f'\u000fR1uC\u000e{gN^3si\u0016\u0014(BA\u0002\u0005\u0003%\u0019wN\u001c<feR,'O\u0003\u0002\u0006\r\u00051qO]5uKJT!a\u0002\u0005\u0002\tA|'n\u001c\u0006\u0003\u0013)\ta!\\8ek2,'BA\u0006\r\u0003\u00159X-\u0019<f\u0015\tia\"\u0001\u0005nk2,7o\u001c4u\u0015\u0005y\u0011aA2p[\u000e\u00011c\u0001\u0001\u00131A\u00111CF\u0007\u0002))\tQ#A\u0003tG\u0006d\u0017-\u0003\u0002\u0018)\t1\u0011I\\=SK\u001a\u00042!\u0007\u000e\u001d\u001b\u0005\u0011\u0011BA\u000e\u0003\u00055!\u0015\r^1D_:4XM\u001d;feB\u0011QDI\u0007\u0002=)\u0011q\u0004I\u0001\u0005kRLGNC\u0001\"\u0003\u0011Q\u0017M^1\n\u0005\rr\"\u0001C\"bY\u0016tG-\u0019:\t\u000b\u0015\u0002A\u0011\u0001\u0014\u0002\rqJg.\u001b;?)\u00059\u0003CA\r\u0001\u0011\u0015I\u0003\u0001\"\u0011+\u0003\u001d\u0019wN\u001c<feR$2a\u000b\u00184!\r\u0019B\u0006H\u0005\u0003[Q\u0011aa\u00149uS>t\u0007\"B\u0018)\u0001\u0004\u0001\u0014AB:pkJ\u001cW\r\u0005\u0002\u0014c%\u0011!\u0007\u0006\u0002\u0004\u0003:L\b\"\u0002\u001b)\u0001\u0004)\u0014AB:dQ\u0016l\u0017\rE\u0002\u0014YY\u0002\"aN\u001f\u000e\u0003aR!\u0001N\u001d\u000b\u0005iZ\u0014!C:ueV\u001cG/\u001e:f\u0015\ta$\"A\u0003n_\u0012,G.\u0003\u0002?q\t11k\u00195f[\u0006DQ\u0001\u0011\u0001\u0005\u0002\u0005\u000b!\"Y:DC2,g\u000eZ1s)\ta\"\tC\u0003D\u007f\u0001\u0007A)\u0001\u0003uS6,\u0007CA#M\u001b\u00051%BA$I\u0003\t\u0011\u0007O\u0003\u0002J\u0015\u0006AA\u000f\u001b:fKR,gNC\u0001L\u0003\ry'oZ\u0005\u0003\u001b\u001a\u0013QBW8oK\u0012$\u0015\r^3US6,\u0007\"B(\u0001\t\u0003\u0001\u0016aC4fiRKW.\u001a.p]\u0016$\"!\u0015+\u0011\u0005u\u0011\u0016BA*\u001f\u0005!!\u0016.\\3[_:,\u0007\"B\"O\u0001\u0004!\u0005\"\u0002,\u0001\t\u00039\u0016A\u00064bY2\u0014\u0017mY6TiJLgnZ\"pKJ\u001c\u0017n\u001c8\u0015\u0005\u0011C\u0006\"B-V\u0001\u0004Q\u0016aA:ueB\u00111LX\u0007\u00029*\u0011Q\fI\u0001\u0005Y\u0006tw-\u0003\u0002`9\n11\u000b\u001e:j]\u001e\u0004")
public class CalendarDataConverter
implements DataConverter<Calendar> {
    @Override
    public Option<String> format(Map<String, Object> arguments) {
        return DataConverter$class.format(this, arguments);
    }

    @Override
    public Option<String> separator(Map<String, Object> arguments) {
        return DataConverter$class.separator(this, arguments);
    }

    @Override
    public Option<String> encoding(Map<String, Object> arguments) {
        return DataConverter$class.encoding(this, arguments);
    }

    @Override
    public Option<Calendar> convert(Object source, Option<Schema> schema) {
        Calendar calendar;
        Object object = source;
        if (object instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(localDateTime.getYear(), localDateTime.getMonthValue() - 1, localDateTime.getDayOfMonth(), localDateTime.getHour(), localDateTime.getMinute(), localDateTime.getSecond());
            instance.set(14, localDateTime.get((TemporalField)ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof ZonedDateTime) {
            ZonedDateTime zonedDateTime = (ZonedDateTime)object;
            calendar = this.asCalendar(zonedDateTime);
        } else if (object instanceof LocalTime) {
            LocalTime localTime = (LocalTime)object;
            Calendar instance = Calendar.getInstance();
            instance.set(11, localTime.getHour());
            instance.set(12, localTime.getMinute());
            instance.set(13, localTime.getSecond());
            instance.set(14, localTime.get((TemporalField)ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof OffsetTime) {
            OffsetTime offsetTime = (OffsetTime)object;
            Calendar instance = Calendar.getInstance(TimeZone.getTimeZone(offsetTime.getOffset().getId()));
            instance.set(11, offsetTime.getHour());
            instance.set(12, offsetTime.getMinute());
            instance.set(13, offsetTime.getSecond());
            instance.set(14, offsetTime.get((TemporalField)ChronoField.MILLI_OF_SECOND));
            calendar = instance;
        } else if (object instanceof LocalDate) {
            LocalDate localDate = (LocalDate)object;
            Calendar instance = Calendar.getInstance();
            instance.set(2, localDate.getMonthValue() - 1);
            instance.set(5, localDate.getDayOfMonth());
            instance.set(1, localDate.getYear());
            instance.set(11, 0);
            instance.set(12, 0);
            instance.set(13, 0);
            instance.set(14, 0);
            calendar = instance;
        } else if (object instanceof Long) {
            long l = BoxesRunTime.unboxToLong((Object)object);
            Calendar instance = Calendar.getInstance();
            instance.setTime(new Date(l));
            calendar = instance;
        } else if (object instanceof String) {
            String string = (String)object;
            ZonedDateTime zonedDateTime = this.fallbackStringCoercion(string);
            calendar = this.asCalendar(zonedDateTime);
        } else {
            Calendar calendar2;
            calendar = object instanceof Calendar ? (calendar2 = (Calendar)object) : null;
        }
        Calendar calendar3 = calendar;
        return Option$.MODULE$.apply((Object)calendar3);
    }

    /*
     * WARNING - void declaration
     */
    public Calendar asCalendar(ZonedDateTime time) {
        void var2_2;
        Calendar instance = Calendar.getInstance(this.getTimeZone(time));
        instance.set(time.getYear(), time.getMonthValue() - 1, time.getDayOfMonth(), time.getHour(), time.getMinute(), time.getSecond());
        instance.set(14, time.get((TemporalField)ChronoField.MILLI_OF_SECOND));
        return var2_2;
    }

    public TimeZone getTimeZone(ZonedDateTime time) {
        String string;
        String string2 = time.getZone().getId();
        TimeZone timeZone = string2 != null && (string = string2).matches("[+-][0-9]{2}:[0-9]{2}") ? TimeZone.getTimeZone(new StringBuilder().append((Object)"GMT").append((Object)time.getZone().getId()).toString()) : TimeZone.getTimeZone(time.getZone().getId());
        return timeZone;
    }

    public ZonedDateTime fallbackStringCoercion(String str) {
        return (ZonedDateTime)Try$.MODULE$.apply((Function0)new Serializable(this, str){
            public static final long serialVersionUID = 0L;
            private final String str$1;

            public final ZonedDateTime apply() {
                return ZonedDateTime.parse((CharSequence)this.str$1);
            }
            {
                this.str$1 = str$1;
            }
        }).orElse((Function0)new Serializable(this, str){
            public static final long serialVersionUID = 0L;
            public final String str$1;

            public final Try<ZonedDateTime> apply() {
                return Try$.MODULE$.apply((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$fallbackStringCoercion$2 $outer;

                    public final ZonedDateTime apply() {
                        return LocalDateTime.parse((CharSequence)this.$outer.str$1).atZone((ZoneId)ZoneOffset.UTC);
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            {
                this.str$1 = str$1;
            }
        }).get();
    }

    public CalendarDataConverter() {
        DataConverter$class.$init$(this);
    }
}

