/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.json.reader;

import com.mulesoft.weave.module.json.reader.IndexedJsonReaderToken;
import com.mulesoft.weave.module.json.reader.JsonLocation;
import com.mulesoft.weave.module.json.reader.JsonLocationCacheBuilder;
import com.mulesoft.weave.module.json.reader.JsonReaderException$;
import com.mulesoft.weave.module.json.reader.JsonTokenFactory;
import com.mulesoft.weave.module.json.reader.JsonTokenHelper$;
import com.mulesoft.weave.module.json.reader.JsonTokenType$;
import com.mulesoft.weave.module.reader.ReaderLocation$;
import com.mulesoft.weave.module.reader.SourceReader;
import com.mulesoft.weave.module.xml.reader.LocationCaches;
import com.mulesoft.weave.module.xml.reader.TokenArray;
import com.mulesoft.weave.module.xml.reader.TokenArray$;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t]a\u0001B\u0001\u0003\u0001=\u0011QBS:p]R{7.\u001a8ju\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\u00193fe*\u0011QAB\u0001\u0005UN|gN\u0003\u0002\b\u0011\u00051Qn\u001c3vY\u0016T!!\u0003\u0006\u0002\u000b],\u0017M^3\u000b\u0005-a\u0011\u0001C7vY\u0016\u001cxN\u001a;\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011!9\u0002A!A!\u0002\u0013A\u0012\u0001\u00028b[\u0016\u0004\"!\u0007\u000f\u000f\u0005EQ\u0012BA\u000e\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QD\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m\u0011\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u000b%t\u0007/\u001e;\u0011\u0005\t\"S\"A\u0012\u000b\u0005\r1\u0011BA\u0013$\u00051\u0019v.\u001e:dKJ+\u0017\rZ3s\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0019\u0011f\u000b\u0017\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000b]1\u0003\u0019\u0001\r\t\u000b\u00012\u0003\u0019A\u0011\t\u000f9\u0002\u0001\u0019!C\u0005_\u0005\u00112-\u001e:t_J\u001c\u0005.\u0019:M_\u000e\fG/[8o+\u0005\u0001\u0004CA\t2\u0013\t\u0011$C\u0001\u0003M_:<\u0007b\u0002\u001b\u0001\u0001\u0004%I!N\u0001\u0017GV\u00148o\u001c:DQ\u0006\u0014Hj\\2bi&|gn\u0018\u0013fcR\u0011a'\u000f\t\u0003#]J!\u0001\u000f\n\u0003\tUs\u0017\u000e\u001e\u0005\buM\n\t\u00111\u00011\u0003\rAH%\r\u0005\u0007y\u0001\u0001\u000b\u0015\u0002\u0019\u0002'\r,(o]8s\u0007\"\f'\u000fT8dCRLwN\u001c\u0011\t\u000fy\u0002\u0001\u0019!C\u0005\u007f\u0005Q1-\u001e:t_J\u001c\u0005.\u0019:\u0016\u0003\u0001\u0003\"!E!\n\u0005\t\u0013\"\u0001B\"iCJDq\u0001\u0012\u0001A\u0002\u0013%Q)\u0001\bdkJ\u001cxN]\"iCJ|F%Z9\u0015\u0005Y2\u0005b\u0002\u001eD\u0003\u0003\u0005\r\u0001\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002!\u0002\u0017\r,(o]8s\u0007\"\f'\u000f\t\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003L\u0003\u0015!W\r\u001d;i+\u0005a\u0005CA\tN\u0013\tq%CA\u0002J]RDq\u0001\u0015\u0001A\u0002\u0013%\u0011+A\u0005eKB$\bn\u0018\u0013fcR\u0011aG\u0015\u0005\bu=\u000b\t\u00111\u0001M\u0011\u0019!\u0006\u0001)Q\u0005\u0019\u00061A-\u001a9uQ\u0002BqA\u0016\u0001C\u0002\u0013%q+A\u0006u_.,gNQ;gM\u0016\u0014X#\u0001-\u0011\u0007ekv,D\u0001[\u0015\t\u00191L\u0003\u0002]\r\u0005\u0019\u00010\u001c7\n\u0005yS&A\u0003+pW\u0016t\u0017I\u001d:bsB\u0011!\u0006Y\u0005\u0003C\n\u0011a#\u00138eKb,GMS:p]J+\u0017\rZ3s)>\\WM\u001c\u0005\u0007G\u0002\u0001\u000b\u0011\u0002-\u0002\u0019Q|7.\u001a8Ck\u001a4WM\u001d\u0011\t\u000f\u0015\u0004!\u0019!C\u0005M\u0006IAn\u0019\"vS2$WM]\u000b\u0002OB\u0011!\u0006[\u0005\u0003S\n\u0011\u0001DS:p]2{7-\u0019;j_:\u001c\u0015m\u00195f\u0005VLG\u000eZ3s\u0011\u0019Y\u0007\u0001)A\u0005O\u0006QAn\u0019\"vS2$WM\u001d\u0011\t\u000b5\u0004A\u0011\u00018\u0002\u0011\u0005$G\rV8lK:$2AN8r\u0011\u0015\u0001H\u000e1\u0001`\u0003\u0015!xn[3o\u0011\u001d\u0011H\u000e%AA\u0002M\fA\u0002];u)>\\WM\\%o\u0019\u000e\u0003\"!\u0005;\n\u0005U\u0014\"a\u0002\"p_2,\u0017M\u001c\u0005\u0006o\u0002!\t\u0001_\u0001\u0007i>\\WM\\:\u0016\u0003e\u0004B!\u0005>Yy&\u00111P\u0005\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005ek\u0018B\u0001@[\u00059aunY1uS>t7)Y2iKNDq!!\u0001\u0001\t\u0013\t\u0019!\u0001\u0005m_\u000e\fG/[8o)\t\t)\u0001E\u0002+\u0003\u000fI1!!\u0003\u0003\u00051Q5o\u001c8M_\u000e\fG/[8o\u0011\u001d\ti\u0001\u0001C\u0005\u0003\u001f\t\u0011B]3bIZ\u000bG.^3\u0015\u0007Y\n\t\u0002\u0003\u0004s\u0003\u0017\u0001\ra\u001d\u0005\b\u0003+\u0001A\u0011BA\f\u0003\u0015IgN\\3s)51\u0014\u0011DA\u000f\u0003\u001b\n\t&!\u0017\u0002^!9\u00111DA\n\u0001\u0004\u0001\u0014AA1u\u0011!\ty\"a\u0005A\u0002\u0005\u0005\u0012!B:uCJ$\b\u0003BA\u0012\u0003\u000frA!!\n\u0002D9!\u0011qEA!\u001d\u0011\tI#a\u0010\u000f\t\u0005-\u0012Q\b\b\u0005\u0003[\tYD\u0004\u0003\u00020\u0005eb\u0002BA\u0019\u0003oi!!a\r\u000b\u0007\u0005Ub\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\r\t)EA\u0001\u000e\u0015N|g\u000eV8lK:$\u0016\u0010]3\n\t\u0005%\u00131\n\u0002\u000e\u0015N|g\u000eV8lK:$\u0016\u0010]3\u000b\u0007\u0005\u0015#\u0001\u0003\u0005\u0002P\u0005M\u0001\u0019AA\u0011\u0003\r)g\u000e\u001a\u0005\t\u0003+\t\u0019\u00021\u0001\u0002TA!\u0011#!\u00167\u0013\r\t9F\u0005\u0002\n\rVt7\r^5p]BBq!a\u0017\u0002\u0014\u0001\u0007\u0001)A\u0002sKFDaA]A\n\u0001\u0004\u0019\bbBA1\u0001\u0011%\u00111M\u0001\re\u0016\fX/\u001b:f\r\u0006d7/\u001a\u000b\u0002m!9\u0011q\r\u0001\u0005\n\u0005\r\u0014a\u0003:fcVL'/\u001a(vY2Dq!a\u001b\u0001\t\u0013\t\u0019'A\u0006sKF,\u0018N]3UeV,\u0007bBA8\u0001\u0011%\u0011\u0011O\u0001\u000be\u0016\fGm\u0015;sS:<GCAA:!\u0011\t\"\u0010\r'\t\u000f\u0005]\u0004\u0001\"\u0003\u0002z\u0005A!/Z1e\u0007\"\f'\u000fF\u0001t\u0011\u001d\ti\b\u0001C\u0005\u0003s\nqB]3bI\u0016\u001b8-\u00199fI\u000eC\u0017M\u001d\u0005\b\u0003\u0003\u0003A\u0011BAB\u0003)\u0011X-\u00193Ok6\u0014WM\u001d\u000b\u0002\u0019\"9\u0011q\u0011\u0001\u0005\n\u0005\r\u0014a\u0002:fC\u0012Le\u000e\u001e\u0005\b\u0003\u0017\u0003A\u0011BA2\u0003!\u0011X-\u00193Ge\u0006\u001c\u0007bBAH\u0001\u0011%\u00111M\u0001\be\u0016\fG-\u0012=q\u0011\u001d\t\u0019\n\u0001C\u0005\u0003G\n1C]3bI>sWm\u0014:N_J,G)[4jiNDq!a&\u0001\t\u0013\t\u0019'\u0001\u000bsK\u0006$',\u001a:p\u001fJluN]3ES\u001eLGo\u001d\u0015\u0005\u0003+\u000bY\n\u0005\u0003\u0002\u001e\u0006\rVBAAP\u0015\r\t\tKE\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAS\u0003?\u0013q\u0001^1jYJ,7\rC\u0004\u0002*\u0002!I!!\u001f\u0002\u0013I,\u0017\r\u001a#jO&$\bbBAW\u0001\u0011%\u00111M\u0001\u000be\u0016\fGm\u00142kK\u000e$\bbBAY\u0001\u0011%\u00111M\u0001\u0012e\u0016\fGm\u00142kK\u000e$X*Z7cKJ\u001c\b\u0006BAX\u00037Cq!a.\u0001\t\u0013\t\u0019'A\u0005sK\u0006$\u0017I\u001d:bs\"9\u00111\u0018\u0001\u0005\n\u0005u\u0016AA<t)\r\u0019\u0018q\u0018\u0005\b\u0003\u0003\fI\f1\u0001A\u0003\u0005\u0019\u0007bBA^\u0001\u0011%\u00111\r\u0015\u0005\u0003\u0007\fY\nC\u0004\u0002J\u0002!I!!\u001f\u0002\u000f\u0005$g/\u00198dK\"9\u0011Q\u001a\u0001\u0005\n\u0005=\u0017AA2i)\r\u0019\u0018\u0011\u001b\u0005\b\u0003\u0003\fY\r1\u0001A\u0011\u001d\t)\u000e\u0001C\u0005\u0003/\fqA]3rk&\u0014X\rF\u00027\u00033Dq!!1\u0002T\u0002\u0007\u0001\tC\u0004\u0002^\u0002!I!a8\u0002\t\u0019\f\u0017\u000e\u001c\u000b\t\u0003C\f9/a;\u0002nB\u0019\u0011#a9\n\u0007\u0005\u0015(CA\u0004O_RD\u0017N\\4\t\u000f\u0005%\u00181\u001ca\u00011\u00051A/\u0019:hKRD!\"!\u0001\u0002\\B\u0005\t\u0019AA\u0003\u0011%\ty/a7\u0011\u0002\u0003\u0007\u0001)A\u0005feJ|'o\u00115be\"I\u00111\u001f\u0001\u0012\u0002\u0013\u0005\u0011Q_\u0001\u0013C\u0012$Gk\\6f]\u0012\"WMZ1vYR$#'\u0006\u0002\u0002x*\u001a1/!?,\u0005\u0005m\b\u0003BA\u007f\u0005\u0007i!!a@\u000b\t\t\u0005\u0011qT\u0001\nk:\u001c\u0007.Z2lK\u0012LAA!\u0002\u0002\u0000\n\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t%\u0001!%A\u0005\n\t-\u0011A\u00044bS2$C-\u001a4bk2$HEM\u000b\u0003\u0005\u001bQC!!\u0002\u0002z\"I!\u0011\u0003\u0001\u0012\u0002\u0013%!1C\u0001\u000fM\u0006LG\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011)BK\u0002A\u0003s\u0004")
public class JsonTokenizer {
    private final String name;
    private final SourceReader input;
    private long cursorCharLocation;
    private char cursorChar;
    private int depth;
    private final TokenArray<IndexedJsonReaderToken> tokenBuffer;
    private final JsonLocationCacheBuilder lcBuilder;

    private long cursorCharLocation() {
        return this.cursorCharLocation;
    }

    private void cursorCharLocation_$eq(long x$1) {
        this.cursorCharLocation = x$1;
    }

    private char cursorChar() {
        return this.cursorChar;
    }

    private void cursorChar_$eq(char x$1) {
        this.cursorChar = x$1;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private TokenArray<IndexedJsonReaderToken> tokenBuffer() {
        return this.tokenBuffer;
    }

    private JsonLocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public void addToken(IndexedJsonReaderToken token, boolean putTokenInLC) {
        this.tokenBuffer().$plus$eq(token);
        if (putTokenInLC) {
            this.lcBuilder().addToken(token, this.tokenBuffer().size() - 1);
        }
    }

    public boolean addToken$default$2() {
        return true;
    }

    public Tuple2<TokenArray<IndexedJsonReaderToken>, LocationCaches> tokens() {
        this.ws();
        this.readValue(false);
        LocationCaches locationCaches = this.lcBuilder().build();
        return new Tuple2(this.tokenBuffer(), (Object)locationCaches);
    }

    private JsonLocation location() {
        return new JsonLocation(this.name, ReaderLocation$.MODULE$.apply(this.cursorCharLocation(), this.input));
    }

    private void readValue(boolean putTokenInLC) {
        long at = this.cursorCharLocation();
        char c = this.cursorChar();
        switch (c) {
            default: {
                throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"false or true or null or {...} or [...] or number but was ", "."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)this.cursorChar())})), this.fail$default$2(), this.fail$default$3());
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.Number(), this.depth(), at, this.readNumber()), putTokenInLC);
                this.ws();
                break;
            }
            case '\"': {
                Tuple2<Object, Object> tuple2 = this.readString();
                if (tuple2 != null) {
                    Tuple2.mcJI.sp sp2;
                    long offset = tuple2._1$mcJ$sp();
                    int length = tuple2._2$mcI$sp();
                    Tuple2.mcJI.sp sp3 = sp2 = new Tuple2.mcJI.sp(offset, length);
                    long offset2 = sp3._1$mcJ$sp();
                    int length2 = sp3._2$mcI$sp();
                    this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.String(), this.depth(), offset2, length2), putTokenInLC);
                    this.ws();
                    break;
                }
                throw new MatchError(tuple2);
            }
            case '[': {
                this.inner(at, JsonTokenType$.MODULE$.ArrayStart(), JsonTokenType$.MODULE$.ArrayEnd(), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JsonTokenizer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.com$mulesoft$weave$module$json$reader$JsonTokenizer$$readArray();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ']', putTokenInLC);
                break;
            }
            case '{': {
                this.inner(at, JsonTokenType$.MODULE$.ObjectStart(), JsonTokenType$.MODULE$.ObjectEnd(), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JsonTokenizer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.com$mulesoft$weave$module$json$reader$JsonTokenizer$$readObject();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, '}', putTokenInLC);
                break;
            }
            case 'n': {
                this.requireNull();
                this.addToken(JsonTokenHelper$.MODULE$.createNull(this.depth(), at), putTokenInLC);
                break;
            }
            case 't': {
                this.requireTrue();
                this.addToken(JsonTokenHelper$.MODULE$.createTrue(this.depth(), at), putTokenInLC);
                break;
            }
            case 'f': {
                this.requireFalse();
                this.addToken(JsonTokenHelper$.MODULE$.createFalse(this.depth(), at), putTokenInLC);
            }
        }
    }

    private void inner(long at, int start, int end, Function0<BoxedUnit> inner, char req, boolean putTokenInLC) {
        IndexedJsonReaderToken startToken = JsonTokenHelper$.MODULE$.create(start, this.depth(), at, 1L);
        this.addToken(startToken, putTokenInLC);
        this.advance();
        this.depth_$eq(this.depth() + 1);
        inner.apply$mcV$sp();
        this.depth_$eq(this.depth() - 1);
        this.require(req);
        this.ws();
    }

    private void requireFalse() {
        this.advance();
        this.require('a');
        this.require('l');
        this.require('s');
        this.require('e');
        this.ws();
    }

    private void requireNull() {
        this.advance();
        this.require('u');
        this.require('l');
        this.require('l');
        this.ws();
    }

    private void requireTrue() {
        this.advance();
        this.require('r');
        this.require('u');
        this.require('e');
        this.ws();
    }

    private Tuple2<Object, Object> readString() {
        this.require('\"');
        long start = this.cursorCharLocation();
        while (this.readChar()) {
            this.advance();
        }
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple2.mcJI.sp(start, length);
    }

    private boolean readChar() {
        boolean bl;
        if ((1L << this.cursorChar() & (long)(31 - this.cursorChar() >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = true;
        } else {
            char c = this.cursorChar();
            switch (c) {
                default: {
                    if (c >= ' ') {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.readEscapedChar();
                    break;
                }
                case '\"': 
                case '\uffff': {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean readEscapedChar() {
        boolean bl;
        char c = this.cursorChar();
        switch (c) {
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
            case 'u': {
                this.advance();
                this.advance();
                this.advance();
                bl = this.advance();
                break;
            }
            case '\"': 
            case '/': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                bl = true;
            }
        }
        return bl;
    }

    private int readNumber() {
        long start = this.cursorCharLocation();
        this.ch('-');
        this.readInt();
        this.readFrac();
        this.readExp();
        return (int)(this.cursorCharLocation() - start);
    }

    private void readInt() {
        if (!this.ch('0')) {
            this.readOneOrMoreDigits();
        }
    }

    private void readFrac() {
        if (this.ch('.')) {
            this.readOneOrMoreDigits();
        }
    }

    private void readExp() {
        if (this.ch('e') || this.ch('E')) {
            boolean bl = this.ch('-') || this.ch('+');
            this.readOneOrMoreDigits();
        }
    }

    private void readOneOrMoreDigits() {
        if (this.readDigit()) {
            this.readZeroOrMoreDigits();
            return;
        }
        throw this.fail("readDigit", this.fail$default$2(), this.fail$default$3());
    }

    private void readZeroOrMoreDigits() {
        while (this.readDigit()) {
        }
    }

    private boolean readDigit() {
        return this.cursorChar() >= '0' && this.cursorChar() <= '9' && this.advance();
    }

    public void com$mulesoft$weave$module$json$reader$JsonTokenizer$$readObject() {
        this.ws();
        if (this.cursorChar() != '}') {
            this.readObjectMembers();
        }
    }

    private void readObjectMembers() {
        Tuple2<Object, Object> tuple2;
        while ((tuple2 = this.readString()) != null) {
            Tuple2.mcJI.sp sp2;
            long offset = tuple2._1$mcJ$sp();
            int length = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp3 = sp2 = new Tuple2.mcJI.sp(offset, length);
            long offset2 = sp3._1$mcJ$sp();
            int length2 = sp3._2$mcI$sp();
            long position = this.input.position();
            String keyName = this.input.readEncodedString(offset2, (long)length2);
            this.input.seek(position);
            this.addToken(JsonTokenHelper$.MODULE$.createKey(keyName, JsonTokenType$.MODULE$.Key(), this.depth(), offset2, length2), this.addToken$default$2());
            this.ws();
            this.require(':');
            this.ws();
            this.readValue(false);
            if (this.ws(',')) continue;
            return;
        }
        throw new MatchError(tuple2);
    }

    public void com$mulesoft$weave$module$json$reader$JsonTokenizer$$readArray() {
        this.ws();
        if (this.cursorChar() != ']') {
            this.values$1();
        }
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar() & (long)(this.cursorChar() - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean advance() {
        this.cursorCharLocation_$eq(this.input.position());
        this.cursorChar_$eq(this.input.readAscii());
        return true;
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar() == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void require(char c) {
        if (this.ch(c)) {
            return;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})), this.fail$default$2(), this.fail$default$3());
    }

    private Nothing$ fail(String target, JsonLocation location, char errorChar) {
        throw JsonReaderException$.MODULE$.apply(target, location, errorChar, this.name);
    }

    private JsonLocation fail$default$2() {
        return this.location();
    }

    private char fail$default$3() {
        return this.cursorChar();
    }

    private final void values$1() {
        do {
            this.readValue(true);
        } while (this.ws(','));
    }

    public JsonTokenizer(String name, SourceReader input) {
        this.name = name;
        this.input = input;
        this.cursorCharLocation = 0L;
        this.cursorChar = input.readAscii();
        this.depth = 0;
        this.tokenBuffer = new TokenArray<IndexedJsonReaderToken>(new JsonTokenFactory(), TokenArray$.MODULE$.$lessinit$greater$default$2());
        this.lcBuilder = new JsonLocationCacheBuilder();
    }
}

