/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.weave.module.json.reader;

import com.mulesoft.weave.module.json.reader.JsonLocation;
import com.mulesoft.weave.module.json.reader.JsonLocationCacheBuilder;
import com.mulesoft.weave.module.json.reader.JsonReaderException;
import com.mulesoft.weave.module.json.reader.JsonTokenHelper$;
import com.mulesoft.weave.module.json.reader.JsonTokenType$;
import com.mulesoft.weave.module.reader.DefaultLongArray;
import com.mulesoft.weave.module.reader.DefaultLongArray$;
import com.mulesoft.weave.module.reader.ILongArray;
import com.mulesoft.weave.module.reader.ReaderLocation$;
import com.mulesoft.weave.module.reader.SourceReader;
import com.mulesoft.weave.module.xml.reader.LocationCaches;
import scala.Function0;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0001\t\u0015b\u0001B\u0001\u0003\u0001=\u0011QBS:p]R{7.\u001a8ju\u0016\u0014(BA\u0002\u0005\u0003\u0019\u0011X-\u00193fe*\u0011QAB\u0001\u0005UN|gN\u0003\u0002\b\u0011\u00051Qn\u001c3vY\u0016T!!\u0003\u0006\u0002\u000b],\u0017M^3\u000b\u0005-a\u0011\u0001C7vY\u0016\u001cxN\u001a;\u000b\u00035\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g\u0011!9\u0002A!A!\u0002\u0013A\u0012\u0001\u00028b[\u0016\u0004\"!\u0007\u000f\u000f\u0005EQ\u0012BA\u000e\u0013\u0003\u0019\u0001&/\u001a3fM&\u0011QD\b\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005m\u0011\u0002\u0002\u0003\u0011\u0001\u0005\u0003\u0005\u000b\u0011B\u0011\u0002\u000b%t\u0007/\u001e;\u0011\u0005\t\"S\"A\u0012\u000b\u0005\r1\u0011BA\u0013$\u00051\u0019v.\u001e:dKJ+\u0017\rZ3s\u0011\u00159\u0003\u0001\"\u0001)\u0003\u0019a\u0014N\\5u}Q\u0019\u0011f\u000b\u0017\u0011\u0005)\u0002Q\"\u0001\u0002\t\u000b]1\u0003\u0019\u0001\r\t\u000b\u00012\u0003\u0019A\u0011\t\u000f9\u0002\u0001\u0019!C\u0005_\u0005\u00112-\u001e:t_J\u001c\u0005.\u0019:M_\u000e\fG/[8o+\u0005\u0001\u0004CA\t2\u0013\t\u0011$C\u0001\u0003M_:<\u0007b\u0002\u001b\u0001\u0001\u0004%I!N\u0001\u0017GV\u00148o\u001c:DQ\u0006\u0014Hj\\2bi&|gn\u0018\u0013fcR\u0011a'\u000f\t\u0003#]J!\u0001\u000f\n\u0003\tUs\u0017\u000e\u001e\u0005\buM\n\t\u00111\u00011\u0003\rAH%\r\u0005\u0007y\u0001\u0001\u000b\u0015\u0002\u0019\u0002'\r,(o]8s\u0007\"\f'\u000fT8dCRLwN\u001c\u0011\t\u000fy\u0002\u0001\u0019!C\u0005\u007f\u0005Q1-\u001e:t_J\u001c\u0005.\u0019:\u0016\u0003\u0001\u0003\"!E!\n\u0005\t\u0013\"\u0001B\"iCJDq\u0001\u0012\u0001A\u0002\u0013%Q)\u0001\bdkJ\u001cxN]\"iCJ|F%Z9\u0015\u0005Y2\u0005b\u0002\u001eD\u0003\u0003\u0005\r\u0001\u0011\u0005\u0007\u0011\u0002\u0001\u000b\u0015\u0002!\u0002\u0017\r,(o]8s\u0007\"\f'\u000f\t\u0005\b\u0015\u0002\u0001\r\u0011\"\u0003L\u0003\u0015!W\r\u001d;i+\u0005a\u0005CA\tN\u0013\tq%CA\u0002J]RDq\u0001\u0015\u0001A\u0002\u0013%\u0011+A\u0005eKB$\bn\u0018\u0013fcR\u0011aG\u0015\u0005\bu=\u000b\t\u00111\u0001M\u0011\u0019!\u0006\u0001)Q\u0005\u0019\u00061A-\u001a9uQ\u0002BqA\u0016\u0001C\u0002\u0013%q+A\u0006u_.,gNQ;gM\u0016\u0014X#\u0001-\u0011\u0005\tJ\u0016B\u0001.$\u0005A!UMZ1vYRduN\\4BeJ\f\u0017\u0010\u0003\u0004]\u0001\u0001\u0006I\u0001W\u0001\ri>\\WM\u001c\"vM\u001a,'\u000f\t\u0005\b=\u0002\u0011\r\u0011\"\u0003`\u0003%a7MQ;jY\u0012,'/F\u0001a!\tQ\u0013-\u0003\u0002c\u0005\tA\"j]8o\u0019>\u001c\u0017\r^5p]\u000e\u000b7\r[3Ck&dG-\u001a:\t\r\u0011\u0004\u0001\u0015!\u0003a\u0003)a7MQ;jY\u0012,'\u000f\t\u0005\u0006M\u0002!\taZ\u0001\tC\u0012$Gk\\6f]R!a\u0007[A\u0001\u0011\u0015IW\r1\u0001k\u0003\u0015!xn[3o!\tYWP\u0004\u0002mw:\u0011QN\u001f\b\u0003]ft!a\u001c=\u000f\u0005A<hBA9w\u001d\t\u0011X/D\u0001t\u0015\t!h\"\u0001\u0004=e>|GOP\u0005\u0002\u001b%\u00111\u0002D\u0005\u0003\u0013)I!a\u0002\u0005\n\u0005\u00151\u0011BA\u0002\u0005\u0013\ta(!A\bKg>tGk\\6f]\"+G\u000e]3s\u0013\tqxPA\u0005Kg>tGk\\6f]*\u0011AP\u0001\u0005\n\u0003\u0007)\u0007\u0013!a\u0001\u0003\u000b\tA\u0002];u)>\\WM\\%o\u0019\u000e\u00032!EA\u0004\u0013\r\tIA\u0005\u0002\b\u0005>|G.Z1o\u0011\u001d\ti\u0001\u0001C\u0001\u0003\u001f\ta\u0001^8lK:\u001cXCAA\t!\u001d\t\u00121CA\f\u0003;I1!!\u0006\u0013\u0005\u0019!V\u000f\u001d7feA\u0019!%!\u0007\n\u0007\u0005m1E\u0001\u0006J\u0019>tw-\u0011:sCf\u0004B!a\b\u0002(5\u0011\u0011\u0011\u0005\u0006\u0004\u0007\u0005\r\"bAA\u0013\r\u0005\u0019\u00010\u001c7\n\t\u0005%\u0012\u0011\u0005\u0002\u000f\u0019>\u001c\u0017\r^5p]\u000e\u000b7\r[3t\u0011\u001d\ti\u0003\u0001C\u0005\u0003_\t\u0001\u0002\\8dCRLwN\u001c\u000b\u0003\u0003c\u00012AKA\u001a\u0013\r\t)D\u0001\u0002\r\u0015N|g\u000eT8dCRLwN\u001c\u0005\b\u0003s\u0001A\u0011BA\u001e\u0003%\u0011X-\u00193WC2,X\rF\u00027\u0003{A\u0001\"a\u0001\u00028\u0001\u0007\u0011Q\u0001\u0005\b\u0003\u0003\u0002A\u0011BA\"\u0003\u0015IgN\\3s)51\u0014QIA%\u00037\ny&a\u001a\u0002l!9\u0011qIA \u0001\u0004\u0001\u0014AA1u\u0011!\tY%a\u0010A\u0002\u00055\u0013!B:uCJ$\b\u0003BA(\u0003+r1\u0001\\A)\u0013\r\t\u0019FA\u0001\u000e\u0015N|g\u000eV8lK:$\u0016\u0010]3\n\t\u0005]\u0013\u0011\f\u0002\u000e\u0015N|g\u000eV8lK:$\u0016\u0010]3\u000b\u0007\u0005M#\u0001\u0003\u0005\u0002^\u0005}\u0002\u0019AA'\u0003\r)g\u000e\u001a\u0005\t\u0003\u0003\ny\u00041\u0001\u0002bA!\u0011#a\u00197\u0013\r\t)G\u0005\u0002\n\rVt7\r^5p]BBq!!\u001b\u0002@\u0001\u0007\u0001)A\u0002sKFD\u0001\"a\u0001\u0002@\u0001\u0007\u0011Q\u0001\u0005\b\u0003_\u0002A\u0011BA9\u00031\u0011X-];je\u00164\u0015\r\\:f)\u00051\u0004bBA;\u0001\u0011%\u0011\u0011O\u0001\fe\u0016\fX/\u001b:f\u001dVdG\u000eC\u0004\u0002z\u0001!I!!\u001d\u0002\u0017I,\u0017/^5sKR\u0013X/\u001a\u0005\b\u0003{\u0002A\u0011BA@\u0003)\u0011X-\u00193TiJLgn\u001a\u000b\u0003\u0003\u0003\u0003R!EA\na1Cq!!\"\u0001\t\u0013\t9)\u0001\u0005sK\u0006$7\t[1s)\t\t)\u0001C\u0004\u0002\f\u0002!I!a\"\u0002\u001fI,\u0017\rZ#tG\u0006\u0004X\rZ\"iCJDq!a$\u0001\t\u0013\t\t*\u0001\u0006sK\u0006$g*^7cKJ$\u0012\u0001\u0014\u0005\b\u0003+\u0003A\u0011BA9\u0003\u001d\u0011X-\u00193J]RDq!!'\u0001\t\u0013\t\t(\u0001\u0005sK\u0006$gI]1d\u0011\u001d\ti\n\u0001C\u0005\u0003c\nqA]3bI\u0016C\b\u000fC\u0004\u0002\"\u0002!I!!\u001d\u0002'I,\u0017\rZ(oK>\u0013Xj\u001c:f\t&<\u0017\u000e^:\t\u000f\u0005\u0015\u0006\u0001\"\u0003\u0002r\u0005!\"/Z1e5\u0016\u0014xn\u0014:N_J,G)[4jiNDC!a)\u0002*B!\u00111VAY\u001b\t\tiKC\u0002\u00020J\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019,!,\u0003\u000fQ\f\u0017\u000e\u001c:fG\"9\u0011q\u0017\u0001\u0005\n\u0005\u001d\u0015!\u0003:fC\u0012$\u0015nZ5u\u0011\u001d\tY\f\u0001C\u0005\u0003c\n!B]3bI>\u0013'.Z2u\u0011\u001d\ty\f\u0001C\u0005\u0003c\n\u0011C]3bI>\u0013'.Z2u\u001b\u0016l'-\u001a:tQ\u0011\ti,!+\t\u000f\u0005\u0015\u0007\u0001\"\u0003\u0002r\u0005I!/Z1e\u0003J\u0014\u0018-\u001f\u0005\b\u0003\u0013\u0004A\u0011BAf\u0003\t98\u000f\u0006\u0003\u0002\u0006\u00055\u0007bBAh\u0003\u000f\u0004\r\u0001Q\u0001\u0002G\"9\u0011\u0011\u001a\u0001\u0005\n\u0005E\u0004\u0006BAi\u0003SCq!a6\u0001\t\u0013\t9)A\u0004bIZ\fgnY3\t\u000f\u0005m\u0007\u0001\"\u0003\u0002^\u0006\u00111\r\u001b\u000b\u0005\u0003\u000b\ty\u000eC\u0004\u0002P\u0006e\u0007\u0019\u0001!\t\u000f\u0005\r\b\u0001\"\u0003\u0002f\u00069!/Z9vSJ,Gc\u0001\u001c\u0002h\"9\u0011qZAq\u0001\u0004\u0001\u0005bBAv\u0001\u0011%\u0011Q^\u0001\u0005M\u0006LG\u000e\u0006\u0005\u0002p\u0006U\u0018\u0011`A~!\r\t\u0012\u0011_\u0005\u0004\u0003g\u0014\"a\u0002(pi\"Lgn\u001a\u0005\b\u0003o\fI\u000f1\u0001\u0019\u0003\u0019!\u0018M]4fi\"Q\u0011QFAu!\u0003\u0005\r!!\r\t\u0013\u0005u\u0018\u0011\u001eI\u0001\u0002\u0004\u0001\u0015!C3se>\u00148\t[1s\u0011%\u0011\t\u0001AI\u0001\n\u0003\u0011\u0019!\u0001\nbI\u0012$vn[3oI\u0011,g-Y;mi\u0012\u0012TC\u0001B\u0003U\u0011\t)Aa\u0002,\u0005\t%\u0001\u0003\u0002B\u0006\u0005#i!A!\u0004\u000b\t\t=\u0011QV\u0001\nk:\u001c\u0007.Z2lK\u0012LAAa\u0005\u0003\u000e\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\t\u0013\t]\u0001!%A\u0005\n\te\u0011A\u00044bS2$C-\u001a4bk2$HEM\u000b\u0003\u00057QC!!\r\u0003\b!I!q\u0004\u0001\u0012\u0002\u0013%!\u0011E\u0001\u000fM\u0006LG\u000e\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\u0019CK\u0002A\u0005\u000f\u0001")
public class JsonTokenizer {
    private final String name;
    private final SourceReader input;
    private long cursorCharLocation;
    private char cursorChar;
    private int depth;
    private final DefaultLongArray tokenBuffer;
    private final JsonLocationCacheBuilder lcBuilder;

    private long cursorCharLocation() {
        return this.cursorCharLocation;
    }

    private void cursorCharLocation_$eq(long x$1) {
        this.cursorCharLocation = x$1;
    }

    private char cursorChar() {
        return this.cursorChar;
    }

    private void cursorChar_$eq(char x$1) {
        this.cursorChar = x$1;
    }

    private int depth() {
        return this.depth;
    }

    private void depth_$eq(int x$1) {
        this.depth = x$1;
    }

    private DefaultLongArray tokenBuffer() {
        return this.tokenBuffer;
    }

    private JsonLocationCacheBuilder lcBuilder() {
        return this.lcBuilder;
    }

    public void addToken(long token, boolean putTokenInLC) {
        this.tokenBuffer().$plus$eq(token);
        if (putTokenInLC) {
            this.lcBuilder().addToken(token, this.tokenBuffer().size() - 1);
        }
    }

    public boolean addToken$default$2() {
        return true;
    }

    public Tuple2<ILongArray, LocationCaches> tokens() {
        this.ws();
        this.readValue(false);
        LocationCaches locationCaches = this.lcBuilder().build();
        return new Tuple2((Object)this.tokenBuffer(), (Object)locationCaches);
    }

    private JsonLocation location() {
        return new JsonLocation(this.name, ReaderLocation$.MODULE$.apply(this.cursorCharLocation(), this.input));
    }

    private void readValue(boolean putTokenInLC) {
        long at = this.cursorCharLocation();
        char c = this.cursorChar();
        switch (c) {
            default: {
                throw this.fail("false or true or null or {...} or [...] or number.", this.fail$default$2(), this.fail$default$3());
            }
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.Number(), this.depth(), at, this.readNumber()), putTokenInLC);
                this.ws();
                break;
            }
            case '\"': {
                Tuple2<Object, Object> tuple2 = this.readString();
                if (tuple2 != null) {
                    Tuple2.mcJI.sp sp2;
                    long offset = tuple2._1$mcJ$sp();
                    int length = tuple2._2$mcI$sp();
                    Tuple2.mcJI.sp sp3 = sp2 = new Tuple2.mcJI.sp(offset, length);
                    long offset2 = sp3._1$mcJ$sp();
                    int length2 = sp3._2$mcI$sp();
                    this.addToken(JsonTokenHelper$.MODULE$.create(JsonTokenType$.MODULE$.String(), this.depth(), offset2, length2), putTokenInLC);
                    this.ws();
                    break;
                }
                throw new MatchError(tuple2);
            }
            case '[': {
                this.inner(at, JsonTokenType$.MODULE$.ArrayStart(), JsonTokenType$.MODULE$.ArrayEnd(), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JsonTokenizer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.com$mulesoft$weave$module$json$reader$JsonTokenizer$$readArray();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, ']', putTokenInLC);
                break;
            }
            case '{': {
                this.inner(at, JsonTokenType$.MODULE$.ObjectStart(), JsonTokenType$.MODULE$.ObjectEnd(), (Function0<BoxedUnit>)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ JsonTokenizer $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.com$mulesoft$weave$module$json$reader$JsonTokenizer$$readObject();
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                }, '}', putTokenInLC);
                break;
            }
            case 'n': {
                this.requireNull();
                this.addToken(JsonTokenHelper$.MODULE$.createNull(this.depth(), at), putTokenInLC);
                break;
            }
            case 't': {
                this.requireTrue();
                this.addToken(JsonTokenHelper$.MODULE$.createTrue(this.depth(), at), putTokenInLC);
                break;
            }
            case 'f': {
                this.requireFalse();
                this.addToken(JsonTokenHelper$.MODULE$.createFalse(this.depth(), at), putTokenInLC);
            }
        }
    }

    private void inner(long at, int start, int end, Function0<BoxedUnit> inner, char req, boolean putTokenInLC) {
        long startToken = JsonTokenHelper$.MODULE$.create(start, this.depth(), at, JsonTokenHelper$.MODULE$.create$default$4());
        this.addToken(startToken, putTokenInLC);
        this.advance();
        this.depth_$eq(this.depth() + 1);
        inner.apply$mcV$sp();
        this.depth_$eq(this.depth() - 1);
        this.require(req);
        this.ws();
    }

    private void requireFalse() {
        this.advance();
        this.require('a');
        this.require('l');
        this.require('s');
        this.require('e');
        this.ws();
    }

    private void requireNull() {
        this.advance();
        this.require('u');
        this.require('l');
        this.require('l');
        this.ws();
    }

    private void requireTrue() {
        this.advance();
        this.require('r');
        this.require('u');
        this.require('e');
        this.ws();
    }

    private Tuple2<Object, Object> readString() {
        this.require('\"');
        long start = this.cursorCharLocation();
        while (this.readChar()) {
            this.advance();
        }
        int length = (int)(this.cursorCharLocation() - start);
        this.require('\"');
        return new Tuple2.mcJI.sp(start, length);
    }

    private boolean readChar() {
        boolean bl;
        if ((1L << this.cursorChar() & (long)(31 - this.cursorChar() >> 31) & 0x7FFFFFFBEFFFFFFFL) != 0L) {
            bl = true;
        } else {
            char c = this.cursorChar();
            switch (c) {
                default: {
                    if (c >= ' ') {
                        bl = true;
                        break;
                    }
                    bl = false;
                    break;
                }
                case '\\': {
                    this.advance();
                    bl = this.readEscapedChar();
                    break;
                }
                case '\"': 
                case '\uffff': {
                    bl = false;
                }
            }
        }
        return bl;
    }

    private boolean readEscapedChar() {
        boolean bl;
        char c = this.cursorChar();
        switch (c) {
            default: {
                throw this.fail("JSON escape sequence", this.fail$default$2(), this.fail$default$3());
            }
            case 'u': {
                this.advance();
                this.advance();
                this.advance();
                bl = this.advance();
                break;
            }
            case '\"': 
            case '/': 
            case '\\': 
            case 'b': 
            case 'f': 
            case 'n': 
            case 'r': 
            case 't': {
                bl = true;
            }
        }
        return bl;
    }

    private int readNumber() {
        long start = this.cursorCharLocation();
        this.ch('-');
        this.readInt();
        this.readFrac();
        this.readExp();
        return (int)(this.cursorCharLocation() - start);
    }

    private void readInt() {
        if (!this.ch('0')) {
            this.readOneOrMoreDigits();
        }
    }

    private void readFrac() {
        if (this.ch('.')) {
            this.readOneOrMoreDigits();
        }
    }

    private void readExp() {
        if (this.ch('e') || this.ch('E')) {
            boolean bl = this.ch('-') || this.ch('+');
            this.readOneOrMoreDigits();
        }
    }

    private void readOneOrMoreDigits() {
        if (this.readDigit()) {
            this.readZeroOrMoreDigits();
            return;
        }
        throw this.fail("readDigit", this.fail$default$2(), this.fail$default$3());
    }

    private void readZeroOrMoreDigits() {
        while (this.readDigit()) {
        }
    }

    private boolean readDigit() {
        return this.cursorChar() >= '0' && this.cursorChar() <= '9' && this.advance();
    }

    public void com$mulesoft$weave$module$json$reader$JsonTokenizer$$readObject() {
        this.ws();
        if (this.cursorChar() != '}') {
            this.readObjectMembers();
        }
    }

    private void readObjectMembers() {
        Tuple2<Object, Object> tuple2;
        while ((tuple2 = this.readString()) != null) {
            Tuple2.mcJI.sp sp2;
            long offset = tuple2._1$mcJ$sp();
            int length = tuple2._2$mcI$sp();
            Tuple2.mcJI.sp sp3 = sp2 = new Tuple2.mcJI.sp(offset, length);
            long offset2 = sp3._1$mcJ$sp();
            int length2 = sp3._2$mcI$sp();
            long position = this.input.position();
            String keyName = this.input.readEncodedString(offset2, (long)length2);
            this.input.seek(position);
            this.addToken(JsonTokenHelper$.MODULE$.createKey(keyName, JsonTokenType$.MODULE$.Key(), this.depth(), offset2, length2), this.addToken$default$2());
            this.ws();
            this.require(':');
            this.ws();
            this.readValue(false);
            if (this.ws(',')) continue;
            return;
        }
        throw new MatchError(tuple2);
    }

    public void com$mulesoft$weave$module$json$reader$JsonTokenizer$$readArray() {
        this.ws();
        if (this.cursorChar() != ']') {
            this.values$1();
        }
    }

    private boolean ws(char c) {
        boolean bl;
        if (this.ch(c)) {
            this.ws();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void ws() {
        while ((1L << this.cursorChar() & (long)(this.cursorChar() - 64 >> 31) & 0x100002600L) != 0L) {
            this.advance();
        }
    }

    private boolean advance() {
        this.cursorCharLocation_$eq(this.input.position());
        this.cursorChar_$eq(this.input.readAscii());
        return true;
    }

    private boolean ch(char c) {
        boolean bl;
        if (this.cursorChar() == c) {
            this.advance();
            bl = true;
        } else {
            bl = false;
        }
        return bl;
    }

    private void require(char c) {
        if (this.ch(c)) {
            return;
        }
        throw this.fail(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"'", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToCharacter((char)c)})), this.fail$default$2(), this.fail$default$3());
    }

    private Nothing$ fail(String target, JsonLocation location, char errorChar) {
        throw new JsonReaderException(target, location, errorChar, this.name);
    }

    private JsonLocation fail$default$2() {
        return this.location();
    }

    private char fail$default$3() {
        return this.cursorChar();
    }

    private final void values$1() {
        do {
            this.readValue(true);
        } while (this.ws(','));
    }

    public JsonTokenizer(String name, SourceReader input) {
        this.name = name;
        this.input = input;
        this.cursorCharLocation = 0L;
        this.cursorChar = input.readAscii();
        this.depth = 0;
        this.tokenBuffer = new DefaultLongArray(DefaultLongArray$.MODULE$.$lessinit$greater$default$1());
        this.lcBuilder = new JsonLocationCacheBuilder();
    }
}

