/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Semaphore;

public class BlockingPipeList<T>
implements List<T>,
Closeable {
    private final Semaphore maxSize;
    private final Object emptySize;
    private boolean closed;
    private final ConcurrentLinkedQueue<T> cache;

    public BlockingPipeList(int pipeSize) {
        this.maxSize = new Semaphore(pipeSize, true);
        this.emptySize = new Object();
        this.closed = false;
        this.cache = new ConcurrentLinkedQueue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(T t) {
        if (this.closed) {
            throw new RuntimeException("Closed Pipe");
        }
        try {
            this.maxSize.acquire();
            Object object = this.emptySize;
            synchronized (object) {
                boolean result = this.cache.add(t);
                this.emptySize.notify();
                return result;
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Un expected exception", e);
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Remove at is not supported");
    }

    @Override
    public boolean containsAll(Collection<?> objects) {
        throw new UnsupportedOperationException("Add at is not supported");
    }

    @Override
    public boolean addAll(Collection<? extends T> values) {
        for (T value : values) {
            this.add(value);
        }
        return true;
    }

    @Override
    public boolean addAll(int i, Collection<? extends T> ts) {
        throw new UnsupportedOperationException("addAll is not supported");
    }

    @Override
    public boolean removeAll(Collection<?> objects) {
        throw new UnsupportedOperationException("removeAll  is not supported");
    }

    @Override
    public boolean retainAll(Collection<?> objects) {
        throw new UnsupportedOperationException("retainAll  is not supported");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear is not supported");
    }

    @Override
    public T get(int i) {
        throw new UnsupportedOperationException("get is not supported");
    }

    @Override
    public T set(int i, T t) {
        throw new UnsupportedOperationException("set is not supported");
    }

    @Override
    public void add(int i, T t) {
        throw new UnsupportedOperationException("Add at is not supported");
    }

    @Override
    public T remove(int i) {
        throw new UnsupportedOperationException("remove is not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.closed = true;
        Object object = this.emptySize;
        synchronized (object) {
            this.emptySize.notify();
        }
    }

    @Override
    public int size() {
        throw new UnsupportedOperationException("size is not supported");
    }

    @Override
    public boolean isEmpty() {
        throw new UnsupportedOperationException("isEmpty is not supported");
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException("contains is not supported");
    }

    @Override
    public Iterator<T> iterator() {
        return new BlockingPileListIterator();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException("Add at is not supported");
    }

    @Override
    public <T1> T1[] toArray(T1[] t1s) {
        throw new UnsupportedOperationException("toArray at is not supported");
    }

    @Override
    public int indexOf(Object o) {
        throw new UnsupportedOperationException("indexOf at is not supported");
    }

    @Override
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException("lastIndexOf at is not supported");
    }

    @Override
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException("listIterator at is not supported");
    }

    @Override
    public ListIterator<T> listIterator(int i) {
        throw new UnsupportedOperationException("listIterator at is not supported");
    }

    @Override
    public List<T> subList(int i, int i2) {
        throw new UnsupportedOperationException("subList at is not supported");
    }

    class BlockingPileListIterator
    implements Iterator<T>,
    Closeable {
        BlockingPileListIterator() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            Object object = BlockingPipeList.this.emptySize;
            synchronized (object) {
                if (BlockingPipeList.this.cache.isEmpty() && !BlockingPipeList.this.closed) {
                    try {
                        BlockingPipeList.this.emptySize.wait();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            }
            return !BlockingPipeList.this.closed || !BlockingPipeList.this.cache.isEmpty();
        }

        @Override
        public T next() {
            Object result = BlockingPipeList.this.cache.poll();
            BlockingPipeList.this.maxSize.release();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Add at is not supported");
        }

        @Override
        public void close() throws IOException {
            BlockingPipeList.this.close();
        }
    }
}

