/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.mule.module.datamapper.processors;

import com.mulesoft.mule.module.datamapper.DataMapperModule;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperCreationException;
import com.mulesoft.mule.module.datamapper.api.exception.DataMapperExecutionException;
import com.mulesoft.mule.module.datamapper.boot.DataMapperLicenseCheck;
import com.mulesoft.mule.module.datamapper.i18n.DataMapperMessages;
import com.mulesoft.mule.module.datamapper.processors.DataMapperGraphConfig;
import com.mulesoft.mule.module.datamapper.processors.DataMapperMessageExecutionException;
import com.mulesource.licm.LicenseKeyException;
import de.schlichtherle.license.LicenseContentException;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang.StringUtils;
import org.mule.api.DefaultMuleException;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.context.MuleContextAware;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.lifecycle.Disposable;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.registry.RegistrationException;
import org.mule.api.transformer.DataType;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.module.xml.transformer.XmlToOutputHandler;
import org.mule.transformer.simple.ObjectToString;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.transport.NullPayload;
import org.mule.util.AttributeEvaluator;

public class DataMapperMessageProcessor
implements MuleContextAware,
Initialisable,
MessageProcessor,
Disposable {
    public static final String CONTENT_TYPE = "Content-Type";
    private DataMapperModule module = new DataMapperModule();
    private Map<String, String> inputArguments = new HashMap<String, String>();
    private DataMapperGraphConfig config;
    private String input;
    private boolean stream = false;
    private int pipeSize = 4024;
    private String returnClass;
    private Class<?> returnClassType;
    private String target;
    private MuleContext muleContext;

    public void initialise() throws InitialisationException {
        try {
            DataMapperLicenseCheck.checkDMEntitlement();
        }
        catch (LicenseContentException e) {
            throw new InitialisationException(new DataMapperMessages().createNoLicenseFound(), (Throwable)e, (Initialisable)this);
        }
        catch (LicenseKeyException e) {
            throw new InitialisationException(new DataMapperMessages().createNoLicenseFound(), (Throwable)e, (Initialisable)this);
        }
        if (this.getConfig() == null) {
            Map configMap = this.muleContext.getRegistry().lookupByType(DataMapperGraphConfig.class);
            if (configMap.size() != 1) {
                throw new InitialisationException(new DataMapperMessages().createNoDefaultConfig(configMap.size()), (Initialisable)this);
            }
            this.setConfig((DataMapperGraphConfig)configMap.values().iterator().next());
        }
        if (this.returnClass != null) {
            try {
                this.returnClassType = Class.forName(this.returnClass);
            }
            catch (ClassNotFoundException e) {
                throw new InitialisationException(new DataMapperMessages().createReturnClassError(), (Throwable)e, (Initialisable)this);
            }
        }
        this.module.setTransformationGraphPath(this.getConfig().getTransformationGraphPath());
        this.module.setInitialPoolSize(this.getConfig().getInitialPoolSize());
        this.module.initialise();
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        ExpressionManager expressionManager = this.muleContext.getExpressionManager();
        HashMap<String, Object> resolvedInputArguments = new HashMap<String, Object>();
        for (Map.Entry<String, String> inputArgumentDef : this.inputArguments.entrySet()) {
            AttributeEvaluator attributeEvaluator = new AttributeEvaluator(inputArgumentDef.getValue());
            attributeEvaluator.initialize(expressionManager);
            resolvedInputArguments.put(inputArgumentDef.getKey(), attributeEvaluator.resolveValue(event.getMessage()));
        }
        try {
            AttributeEvaluator inputEvaluator = new AttributeEvaluator(this.getInput());
            inputEvaluator.initialize(expressionManager);
            Object inputObject = inputEvaluator.resolveValue(event.getMessage());
            inputObject = this.transformInputIfRequired(inputObject);
            Object dmResult = this.module.transform(event, inputObject, resolvedInputArguments, this.stream, this.pipeSize);
            dmResult = this.transformOutputIfRequired(event, dmResult);
            if (this.hasTargetDefined()) {
                this.muleContext.getExpressionManager().enrich(this.target, event, dmResult);
            } else {
                event.getMessage().setPayload(dmResult);
            }
            if (!this.hasTargetDefined()) {
                String outputEncoding;
                String outputContentType = this.module.getOutputContentType();
                if (!StringUtils.isEmpty((String)outputContentType)) {
                    event.getMessage().setOutboundProperty(CONTENT_TYPE, (Object)outputContentType);
                }
                if (!StringUtils.isEmpty((String)(outputEncoding = this.module.getOutputEncoding()))) {
                    event.getMessage().setEncoding(outputEncoding);
                }
            }
            return event;
        }
        catch (DataMapperExecutionException e) {
            throw new DataMapperMessageExecutionException(event, e);
        }
        catch (DataMapperCreationException e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    private Object transformOutputIfRequired(MuleEvent event, Object dmResult) throws TransformerException {
        if (this.returnClassType != null) {
            DataType source = DataTypeFactory.createFromObject((Object)dmResult);
            DataType resultType = DataTypeFactory.create(this.returnClassType);
            if (!resultType.isCompatibleWith(source)) {
                Transformer transformer = this.muleContext.getRegistry().lookupTransformer(source, resultType);
                if (transformer == null) {
                    throw new TransformerException(CoreMessages.noTransformerFoundForMessage((DataType)source, (DataType)resultType));
                }
                dmResult = transformer.transform(dmResult, event.getEncoding());
            }
        }
        return dmResult;
    }

    private Object transformInputIfRequired(Object inputObject) throws RegistrationException, DefaultMuleException, TransformerException {
        if (inputObject instanceof XMLStreamReader) {
            XmlToOutputHandler xmlToOutputHandler = (XmlToOutputHandler)this.muleContext.getRegistry().lookupObject(XmlToOutputHandler.class);
            if (xmlToOutputHandler == null) {
                throw new DefaultMuleException("Missing transformer XmlToOutputHandler");
            }
            Object transform = xmlToOutputHandler.transform(inputObject);
            inputObject = new ObjectToString().transform(transform);
        } else if (inputObject == null) {
            return NullPayload.getInstance();
        }
        return inputObject;
    }

    private boolean hasTargetDefined() {
        return !StringUtils.isEmpty((String)this.target) && !this.isPayloadExpression(this.target);
    }

    private boolean isPayloadExpression(String target) {
        return "#[payload]".equals(target);
    }

    public void setMuleContext(MuleContext context) {
        this.muleContext = context;
        this.module.setMuleContext(context);
    }

    public String getTarget() {
        return this.target;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public Map<String, String> getInputArguments() {
        return this.inputArguments;
    }

    public void setInputArguments(Map<String, String> inputArguments) {
        this.inputArguments = inputArguments;
    }

    public DataMapperGraphConfig getConfig() {
        return this.config;
    }

    public void setConfig(DataMapperGraphConfig config) {
        this.config = config;
    }

    public String getInput() {
        return this.input;
    }

    public void setInput(String input) {
        this.input = input;
    }

    public boolean isStream() {
        return this.stream;
    }

    public void setStream(boolean stream) {
        this.stream = stream;
    }

    public int getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(int pipeSize) {
        this.pipeSize = pipeSize;
    }

    public String getReturnClass() {
        return this.returnClass;
    }

    public void setReturnClass(String returnClass) {
        this.returnClass = returnClass;
    }

    public void dispose() {
        if (this.module != null) {
            this.module.dispose();
        }
    }
}

